/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.name;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class Names
extends TokenSet
implements Index {
    private Stats[] stats;
    private final MetaData meta;

    public Names(MetaData md) {
        this.stats = new Stats[8];
        this.meta = md;
    }

    public Names(DataInput in, MetaData md) throws IOException {
        super(in);
        this.stats = new Stats[this.keys.length];
        this.meta = md;
        for (int s = 1; s < this.size; ++s) {
            this.stats[s] = new Stats(in);
        }
    }

    @Override
    public void init() {
        for (int s = 1; s < this.size; ++s) {
            this.stats[s] = new Stats();
        }
    }

    public int index(byte[] n, byte[] v, boolean st) {
        int id = this.put(n);
        if (st) {
            if (this.stats[id] == null) {
                this.stats[id] = new Stats();
            }
            Stats stat = this.stats[id];
            if (v != null) {
                stat.add(v, this.meta);
            }
            ++stat.count;
        }
        return id;
    }

    public void index(int n, byte[] v) {
        this.stats[n].add(v, this.meta);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        for (int s = 1; s < this.size; ++s) {
            if (this.stats[s] == null) {
                this.stats[s] = new Stats();
            }
            this.stats[s].write(out);
        }
    }

    public Stats stat(int id) {
        return this.stats[id];
    }

    @Override
    public byte[] info() {
        int[] tl = new int[this.size];
        tl[0] = 0;
        int len = 0;
        for (int i = 1; i < this.size; ++i) {
            if (len < this.keys[i].length) {
                len = this.keys[i].length;
            }
            if (this.stats[i] == null) continue;
            tl[i] = this.stats[i].count;
        }
        len += 2;
        int[] ids = Array.createOrder(tl, false);
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Hash" + Text.NL);
        tb.add("- Entries: " + (this.size - 1) + Text.NL);
        for (int i = 0; i < this.size - 1; ++i) {
            int s = ids[i];
            if (this.stats[s] == null) continue;
            byte[] key = this.keys[s];
            tb.add("  ");
            tb.add(key);
            for (int j = 0; j < len - key.length; ++j) {
                tb.add(32);
            }
            tb.add(this.stats[s] + Text.NL);
        }
        return tb.finish();
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        return new EntryIterator(){
            int c;

            @Override
            public byte[] next() {
                return ++this.c < Names.this.size ? Names.this.keys[this.c] : null;
            }

            @Override
            public int count() {
                return ((Names)Names.this).stats[this.c].count;
            }
        };
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.stats = Array.copy(this.stats, new Stats[s]);
    }

    @Override
    public void close() {
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public int costs(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }
}

