/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexTree;
import org.basex.index.value.DiskValues;
import org.basex.index.value.UpdatableDiskValues;
import org.basex.index.value.ValueIndexMerger;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class ValueIndexBuilder
extends IndexBuilder {
    private IndexTree index = new IndexTree();
    private final boolean text;

    public ValueIndexBuilder(Data d, boolean txt) {
        super(d, d.meta.options.get(MainOptions.INDEXSPLITSIZE));
        this.text = txt;
    }

    @Override
    public DiskValues build() throws IOException {
        this.abort();
        Performance perf = Prop.debug ? new Performance() : null;
        Util.debug(this.det(), new Object[0]);
        int k = this.text ? 2 : 3;
        this.pre = 0;
        while (this.pre < this.size) {
            if ((this.pre & 0xFFF) == 0) {
                this.check();
                if (this.split()) {
                    this.writeIndex(true);
                    this.index = new IndexTree();
                    this.finishSplit();
                }
            }
            if (this.data.kind(this.pre) == k && this.data.textLen(this.pre, this.text) <= this.data.meta.maxlen) {
                this.index.index(this.data.text(this.pre, this.text), this.data.meta.updindex ? this.data.id(this.pre) : this.pre);
                ++this.count;
            }
            ++this.pre;
        }
        this.writeIndex(this.splits > 0);
        if (this.splits > 1) {
            this.index = null;
            Performance.gc(1);
            this.merge();
        }
        if (this.text) {
            this.data.meta.textindex = true;
        } else {
            this.data.meta.attrindex = true;
        }
        this.finishIndex(perf);
        return this.data.meta.updindex ? new UpdatableDiskValues(this.data, this.text) : new DiskValues(this.data, this.text);
    }

    private void merge() throws IOException {
        String f = this.text ? "txt" : "atv";
        DataOutput outL = new DataOutput(this.data.meta.dbfile(f + 'l'));
        DataOutput outR = new DataOutput(this.data.meta.dbfile(f + 'r'));
        outL.write4(0);
        IntList ml = new IntList();
        IntList il = new IntList();
        ValueIndexMerger[] vm = new ValueIndexMerger[this.splits];
        for (int i = 0; i < this.splits; ++i) {
            vm[i] = new ValueIndexMerger(this.data, this.text, i);
        }
        int sz = 0;
        while (true) {
            this.checkStop();
            int min = -1;
            while (++min < this.splits && vm[min].values.length == 0) {
            }
            if (min == this.splits) break;
            ml.reset();
            for (int i = min; i < this.splits; ++i) {
                int d;
                if (vm[i].values.length == 0 || (d = Token.diff(vm[min].key, vm[i].key)) < 0) continue;
                if (d > 0) {
                    min = i;
                    ml.reset();
                }
                ml.add(i);
            }
            int ms = ml.size();
            for (int m = 0; m < ms; ++m) {
                int v;
                ValueIndexMerger t = vm[ml.get(m)];
                int vl = t.values.length;
                for (int l = 4; l < vl; l += Num.length(v)) {
                    v = Num.get(t.values, l);
                    il.add(v);
                }
                t.next();
            }
            ValueIndexBuilder.write(outL, outR, il);
            ++sz;
        }
        outR.close();
        outL.close();
        DataAccess da = new DataAccess(this.data.meta.dbfile(f + 'l'));
        da.write4(sz);
        da.close();
    }

    private void writeIndex(boolean partial) throws IOException {
        String name = (this.text ? "txt" : "atv") + (partial ? Integer.valueOf(this.splits) : "");
        DataOutput outL = new DataOutput(this.data.meta.dbfile(name + 'l'));
        DataOutput outR = new DataOutput(this.data.meta.dbfile(name + 'r'));
        outL.write4(this.index.size());
        IntList il = new IntList();
        this.index.init();
        while (this.index.more()) {
            byte[] values = this.index.values.get(this.index.next());
            int vs = Num.size(values);
            if (partial) {
                outR.write5(outL.size());
                outL.write(values, 0, vs);
                continue;
            }
            for (int ip = 4; ip < vs; ip += Num.length(values, ip)) {
                il.add(Num.get(values, ip));
            }
            ValueIndexBuilder.write(outL, outR, il);
        }
        outL.close();
        outR.close();
        if (partial) {
            DataOutput outT = new DataOutput(this.data.meta.dbfile(name + 't'));
            this.index.init();
            while (this.index.more()) {
                outT.writeToken(this.index.keys.get(this.index.next()));
            }
            outT.close();
        }
        ++this.splits;
    }

    private static void write(DataOutput outL, DataOutput outR, IntList il) throws IOException {
        il.sort();
        int is = il.size();
        outR.write5(outL.size());
        outL.writeNum(is);
        int o = 0;
        for (int i = 0; i < is; ++i) {
            int v = il.get(i);
            outL.writeNum(v - o);
            o = v;
        }
        il.reset();
    }

    @Override
    protected void abort() {
        this.data.meta.drop((this.text ? "txt" : "atv") + ".+");
        if (this.text) {
            this.data.meta.textindex = false;
        } else {
            this.data.meta.attrindex = false;
        }
    }

    @Override
    protected String det() {
        return this.text ? Text.INDEX_TEXT_D : Text.INDEX_ATTRIBUTES_D;
    }
}

