/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.CsvOptions;
import org.basex.build.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

final class CsvDirectConverter
extends CsvConverter {
    private static final byte[] CSV = Token.token("csv");
    private static final byte[] RECORD = Token.token("record");
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] NAME = Token.token("name");
    private final TokenList headers = new TokenList();
    private final boolean atts;
    private final boolean lax;
    private final FElem root = new FElem(CSV);
    private FElem record;
    private int col;

    CsvDirectConverter(CsvParserOptions opts) {
        super(opts);
        this.lax = opts.get(CsvOptions.LAX);
        this.atts = opts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
    }

    @Override
    public void record() {
        this.record = new FElem(RECORD);
        this.root.add(this.record);
        this.col = 0;
    }

    @Override
    public void header(byte[] value) {
        this.headers.add(this.atts ? value : XMLToken.encode(value, this.lax));
    }

    @Override
    public void entry(byte[] entry) {
        FElem e;
        byte[] name = this.headers.get(this.col++);
        if (this.atts) {
            e = new FElem(ENTRY);
            if (name != null) {
                e.add(NAME, name);
            }
        } else {
            e = new FElem(name == null ? ENTRY : name);
        }
        this.record.add(e.add(entry));
    }

    @Override
    public FDoc finish() {
        return new FDoc().add(this.root);
    }
}

