/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.ByteList;

abstract class JsonXmlConverter
extends JsonConverter {
    private final TokenObjMap<TypeCache> names = new TokenObjMap();
    private final boolean merge = this.jopts.get(JsonOptions.MERGE);
    private final boolean strings = this.jopts.get(JsonOptions.STRINGS);
    FElem elem;

    JsonXmlConverter(JsonParserOptions opts) {
        super(opts);
    }

    FElem element() {
        if (this.elem == null) {
            this.elem = new FElem(JsonConstants.JSON);
        }
        return this.elem;
    }

    @Override
    public FDoc finish() {
        FElem e = this.element();
        if (this.merge) {
            ByteList[] types = new ByteList[JsonConstants.ATTRS.length];
            block0: for (TypeCache arr : this.names.values()) {
                if (arr == null) continue;
                for (int i = 0; i < JsonConstants.TYPES.length; ++i) {
                    if (arr.type != JsonConstants.TYPES[i] || !this.strings && arr.type == JsonConstants.STRING) continue;
                    if (types[i] == null) {
                        types[i] = new ByteList();
                    } else {
                        types[i].add(32);
                    }
                    types[i].add(arr.name);
                    continue block0;
                }
            }
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) continue;
                e.add(JsonConstants.ATTRS[i], types[i].toArray());
            }
        }
        return new FDoc().add(e);
    }

    void addType(FElem e, byte[] name, byte[] type) {
        if (this.merge) {
            if (name != null && !Token.contains(name, 32)) {
                if (this.names.contains(name)) {
                    TypeCache arr = this.names.get(name);
                    if (arr != null && arr.type == type) {
                        arr.add(e);
                    } else {
                        if (arr != null) {
                            for (int i = 0; i < arr.size; ++i) {
                                this.addType(arr.vals[i], arr.type);
                            }
                            this.names.put(name, null);
                        }
                        this.addType(e, type);
                    }
                } else {
                    this.names.put(name, new TypeCache(name, type, e));
                }
            } else {
                this.addType(e, type);
            }
        } else {
            this.addType(e, type);
        }
    }

    private void addType(FElem e, byte[] type) {
        if (this.strings || type != JsonConstants.STRING) {
            e.add(JsonConstants.TYPE, type);
        }
    }

    static final class TypeCache {
        public final byte[] type;
        public final byte[] name;
        public FElem[] vals = new FElem[8];
        public int size;

        TypeCache(byte[] nm, byte[] tp, FElem nd) {
            this.name = nm;
            this.type = tp;
            this.vals[0] = nd;
            this.size = 1;
        }

        public void add(FElem nd) {
            if (this.size == this.vals.length) {
                this.vals = Array.copy(this.vals, new FElem[Array.newSize(this.size)]);
            }
            this.vals[this.size++] = nd;
        }
    }
}

