/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class HTMLSerializer
extends OutputSerializer {
    static final TokenList EMPTIES = new TokenList();
    static final TokenList EMPTIES5 = new TokenList();
    static final TokenSet URIS = new TokenSet();
    private static final TokenList SCRIPTS = new TokenList();
    private static final TokenSet BOOLEAN = new TokenSet();

    HTMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, "4.0", "4.01", "5.0");
    }

    @Override
    protected void attribute(byte[] n, byte[] v) throws IOException {
        this.print(32);
        this.print(n);
        byte[] tagatt = Token.concat(Token.lc(this.tag), Token.COLON, Token.lc(n));
        if (BOOLEAN.contains(tagatt) && Token.eq(n, v)) {
            return;
        }
        byte[] val = this.escuri && URIS.contains(tagatt) ? Token.escape(v) : v;
        this.print(DataText.ATT1);
        for (int k = 0; k < val.length; k += Token.cl(val, k)) {
            int ch = Token.cp(val, k);
            if (ch == 60 || ch == 38 && val[Math.min(k + 1, val.length - 1)] == 123) {
                this.print(ch);
                continue;
            }
            if (ch == 34) {
                this.print(DataText.E_QU);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.hex(ch);
                continue;
            }
            this.encode(ch);
        }
        this.print(DataText.ATT2);
    }

    @Override
    protected void finishComment(byte[] n) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
    }

    @Override
    protected void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.sep) {
            this.indent();
        }
        if (Token.contains(v, 62)) {
            throw Err.SERPI.getIO(new Object[0]);
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void encode(int ch) throws IOException {
        if (this.script) {
            this.printChar(ch);
        } else {
            if (ch > 127 && ch < 160 && !this.html5) {
                throw Err.SERILL.getIO(Integer.toHexString(ch));
            }
            if (ch == 160) {
                this.print(DataText.E_NBSP);
            } else {
                super.encode(ch);
            }
        }
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(null);
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.sep = this.indent;
        this.script = SCRIPTS.contains(Token.lc(t));
        if (this.content && Token.eq(Token.lc(this.tag), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.ct(false, true);
    }

    @Override
    protected void finishEmpty() throws IOException {
        byte[] u;
        if (this.ct(true, true)) {
            return;
        }
        this.print(DataText.ELEM_C);
        if (this.html5 ? EMPTIES5.contains(Token.lc(this.tag)) : EMPTIES.contains(Token.lc(this.tag)) && ((u = this.nsUri(Token.EMPTY)) == null || u.length == 0)) {
            return;
        }
        this.sep = false;
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        super.finishClose();
        this.script = this.script && !SCRIPTS.contains(Token.lc(this.tag));
    }

    @Override
    boolean doctype(byte[] dt) throws IOException {
        if (this.level != 0) {
            return false;
        }
        if (!super.doctype(dt) && this.html5) {
            if (this.sep) {
                this.indent();
            }
            this.print("<!DOCTYPE ");
            if (dt == null) {
                this.print("html");
            } else {
                this.print(dt);
            }
            this.print(DataText.ELEM_C);
            if (this.indent) {
                this.print(this.nl);
            }
        }
        return true;
    }

    static {
        SCRIPTS.add("script");
        SCRIPTS.add("style");
        BOOLEAN.add("area:nohref");
        BOOLEAN.add("button:disabled");
        BOOLEAN.add("dir:compact");
        BOOLEAN.add("dl:compact");
        BOOLEAN.add("frame:noresize");
        BOOLEAN.add("hr:noshade");
        BOOLEAN.add("img:ismap");
        BOOLEAN.add("input:checked");
        BOOLEAN.add("input:disabled");
        BOOLEAN.add("input:readonly");
        BOOLEAN.add("menu:compact");
        BOOLEAN.add("object:declare");
        BOOLEAN.add("ol:compact");
        BOOLEAN.add("optgroup:disabled");
        BOOLEAN.add("option:selected");
        BOOLEAN.add("option:disabled");
        BOOLEAN.add("script:defer");
        BOOLEAN.add("select:multiple");
        BOOLEAN.add("select:disabled");
        BOOLEAN.add("td:nowrap");
        BOOLEAN.add("textarea:disabled");
        BOOLEAN.add("textarea:readonly");
        BOOLEAN.add("th:nowrap");
        BOOLEAN.add("ul:compact");
        EMPTIES.add("area");
        EMPTIES.add("base");
        EMPTIES.add("br");
        EMPTIES.add("col");
        EMPTIES.add("embed");
        EMPTIES.add("hr");
        EMPTIES.add("img");
        EMPTIES.add("input");
        EMPTIES.add("link");
        EMPTIES.add("meta");
        EMPTIES.add("basefont");
        EMPTIES.add("frame");
        EMPTIES.add("isindex");
        EMPTIES.add("param");
        EMPTIES5.add("area");
        EMPTIES5.add("base");
        EMPTIES5.add("br");
        EMPTIES5.add("col");
        EMPTIES5.add("command");
        EMPTIES5.add("embed");
        EMPTIES5.add("hr");
        EMPTIES5.add("img");
        EMPTIES5.add("input");
        EMPTIES5.add("keygen");
        EMPTIES5.add("link");
        EMPTIES5.add("meta");
        EMPTIES5.add("param");
        EMPTIES5.add("source");
        EMPTIES5.add("track");
        EMPTIES5.add("wbr");
        EMPTIES5.add("basefont");
        EMPTIES5.add("frame");
        EMPTIES5.add("isindex");
        URIS.add("a:href");
        URIS.add("a:name");
        URIS.add("applet:codebase");
        URIS.add("area:href");
        URIS.add("base:href");
        URIS.add("blockquote:cite");
        URIS.add("body:background");
        URIS.add("button:datasrc");
        URIS.add("del:cite");
        URIS.add("div:datasrc");
        URIS.add("form:action");
        URIS.add("frame:longdesc");
        URIS.add("frame:src");
        URIS.add("head:profile");
        URIS.add("iframe:longdesc");
        URIS.add("iframe:src");
        URIS.add("img:longdesc");
        URIS.add("img:src");
        URIS.add("img:usemap");
        URIS.add("input:datasrc");
        URIS.add("input:src");
        URIS.add("input:usemap");
        URIS.add("ins:cite");
        URIS.add("link:href");
        URIS.add("object:archive");
        URIS.add("object:classid");
        URIS.add("object:codebase");
        URIS.add("object:data");
        URIS.add("object:datasrc");
        URIS.add("object:usemap");
        URIS.add("q:cite");
        URIS.add("script:for");
        URIS.add("script:src");
        URIS.add("select:datasrc");
        URIS.add("span:datasrc");
        URIS.add("table:datasrc");
        URIS.add("textarea:datasrc");
    }
}

