/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.CsvOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.TokenList;

public final class CsvDirectSerializer
extends CsvSerializer {
    private final TokenList headers;
    private final boolean atts;
    private final boolean lax;
    private boolean header;
    private TokenMap data;
    private byte[] attv;

    public CsvDirectSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
        this.header = this.copts.get(CsvOptions.HEADER);
        this.headers = this.header ? new TokenList() : null;
        this.atts = this.copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
        this.lax = this.copts.get(CsvOptions.LAX) != false || this.atts;
    }

    @Override
    protected void startOpen(byte[] name) {
        if (this.level == 1) {
            this.data = new TokenMap();
        }
        this.attv = null;
    }

    @Override
    protected void finishOpen() {
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        if (this.level == 2) {
            this.cache(Token.EMPTY);
        }
        this.finishClose();
    }

    @Override
    protected void finishText(byte[] text) throws IOException {
        if (this.level == 3) {
            this.cache(text);
        }
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.level != 1) {
            return;
        }
        if (this.headers != null) {
            int i;
            TokenList tl;
            int s = this.headers.size();
            if (this.header) {
                tl = new TokenList();
                for (i = 0; i < s; ++i) {
                    tl.add(this.headers.get(i));
                }
                this.record(tl);
                this.header = false;
            }
            tl = new TokenList();
            for (i = 0; i < s; ++i) {
                tl.add(this.data.get(this.headers.get(i)));
            }
            this.record(tl);
        } else {
            TokenList tl = new TokenList();
            for (byte[] v : this.data.values()) {
                tl.add(v);
            }
            this.record(tl);
        }
    }

    @Override
    protected void attribute(byte[] n, byte[] v) {
        this.attv = v;
    }

    @Override
    protected void finishComment(byte[] n) {
    }

    @Override
    protected void finishPi(byte[] n, byte[] v) {
    }

    @Override
    protected void atomic(Item value, boolean iter) throws IOException {
        CsvDirectSerializer.error("Atomic values cannot be serialized", new Object[0]);
    }

    @Override
    protected void encode(int ch) throws IOException {
        this.printChar(ch);
    }

    private void cache(byte[] text) throws IOException {
        if (this.headers != null) {
            byte[] old;
            byte[] key = this.atts && this.attv != null ? this.attv : this.tag;
            byte[] name = XMLToken.decode(key, this.lax);
            if (name == null) {
                CsvDirectSerializer.error("Invalid element name <%>", new Object[]{key});
            }
            if (!this.headers.contains(name)) {
                this.headers.add(name);
            }
            byte[] txt = (old = this.data.get(name)) == null || old.length == 0 ? text : (text.length == 0 ? old : new TokenBuilder(old).add(44).add(text).finish());
            this.data.put(name, txt);
        } else {
            this.data.put(Token.token(this.data.size()), text);
        }
    }

    private static void error(String msg, Object ... ext) throws IOException {
        throw Err.BXCS_SERIAL.getIO(new Object[]{Util.inf(msg, ext)});
    }
}

