/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Single;
import org.basex.query.iter.ValueIter;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Extension
extends Single {
    private final Pragma[] pragmas;

    public Extension(InputInfo ii, Pragma[] prag, Expr e) {
        super(ii, e);
        this.pragmas = prag;
    }

    @Override
    public void checkUp() throws QueryException {
        this.expr.checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        try {
            for (Pragma p : this.pragmas) {
                p.init(ctx, this.info);
            }
            this.expr = this.expr.compile(ctx, scp);
            this.type = this.expr.type();
            this.size = this.expr.size();
        }
        finally {
            for (Pragma p : this.pragmas) {
                p.finish(ctx);
            }
        }
        return this;
    }

    @Override
    public ValueIter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        try {
            for (Pragma p : this.pragmas) {
                p.init(ctx, this.info);
            }
            Value value = ctx.value(this.expr);
            return value;
        }
        finally {
            for (Pragma p : this.pragmas) {
                p.finish(ctx);
            }
        }
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Pragma[] prag = (Pragma[])this.pragmas.clone();
        for (int i = 0; i < prag.length; ++i) {
            prag[i] = prag[i].copy();
        }
        return this.copyType(new Extension(this.info, prag, this.expr.copy(ctx, scp, vs)));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.pragmas, this.expr});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Pragma p : this.pragmas) {
            sb.append(p).append(' ');
        }
        return sb.append("{ ").append(this.expr).append(' ').append("}").toString();
    }
}

