/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.IterPosFilter;
import org.basex.query.expr.Preds;
import org.basex.query.path.AxisPath;
import org.basex.query.path.Path;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Filter
extends Preds {
    public Expr root;

    Filter(InputInfo ii, Expr r, Expr ... p) {
        super(ii, p);
        this.root = r;
    }

    public static Filter get(InputInfo ii, Expr r, Expr ... p) {
        return new CachedFilter(ii, r, p);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        super.checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        Value cv = ctx.value;
        try {
            this.root = this.root.compile(ctx, scp);
            if (this.root.isEmpty()) {
                Expr expr = this.optPre(null, ctx);
                return expr;
            }
            if (this.root instanceof AxisPath && !super.has(Expr.Flag.FCS)) {
                Expr expr = ((Path)this.root.copy(ctx, scp)).addPreds(ctx, scp, this.preds).compile(ctx, scp);
                return expr;
            }
            ctx.value = null;
            Expr e = super.compile(ctx, scp);
            if (e != this) {
                Expr expr = e;
                return expr;
            }
            Expr expr = this.preds.length == 0 ? this.root : this.opt(ctx);
            return expr;
        }
        finally {
            ctx.value = cv;
        }
    }

    private Expr opt(QueryContext ctx) {
        SeqType t = this.root.type();
        long s = this.root.size();
        if (s == -1L) {
            this.type = SeqType.get(t.type, t.zeroOrOne() ? SeqType.Occ.ZERO_ONE : SeqType.Occ.ZERO_MORE);
        } else {
            if (this.pos != null) {
                this.size = Math.max(0L, s + 1L - this.pos.min) - Math.max(0L, s - this.pos.max);
            } else if (this.last) {
                long l = this.size = s > 0L ? 1L : 0L;
            }
            if (this.size == 0L) {
                return this.optPre(null, ctx);
            }
            this.type = SeqType.get(t.type, this.size);
        }
        if (!super.has(Expr.Flag.FCS)) {
            return new IterFilter(this);
        }
        boolean iter = this.posIterator();
        if (this.preds.length == 1 && (this.last || this.pos != null) && this.root.isValue()) {
            Value v = (Value)this.root;
            long from = this.last ? v.size() - 1L : this.pos.min - 1L;
            long len = this.last ? 1L : this.pos.max - from;
            return this.optPre(SubSeq.get(v, from, len), ctx);
        }
        boolean off = false;
        if (this.preds.length == 1) {
            Expr p = this.preds[0];
            SeqType st = p.type();
            boolean bl = off = st.type.isNumber() && st.zeroOrOne() && !p.has(Expr.Flag.CTX) && !p.has(Expr.Flag.NDT);
            if (off) {
                this.type = SeqType.get(this.type.type, SeqType.Occ.ZERO_ONE);
            }
        }
        return off || iter ? new IterPosFilter(this, off) : this;
    }

    public abstract Filter addPred(QueryContext var1, VarScope var2, Expr var3) throws QueryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        Value cv = ctx.value;
        try {
            if (this.root.isEmpty()) {
                Expr expr = this.optPre(null, ctx);
                return expr;
            }
            if (this.root instanceof AxisPath && !super.has(Expr.Flag.FCS)) {
                Expr expr = ((Path)this.root.copy(ctx, scp)).addPreds(ctx, scp, this.preds);
                return expr;
            }
            Expr expr = this.preds.length == 0 ? this.root : this.opt(ctx);
            return expr;
        }
        finally {
            ctx.value = cv;
        }
    }

    @Override
    public final boolean has(Expr.Flag flag) {
        return this.root.has(flag) || flag != Expr.Flag.CTX && super.has(flag);
    }

    @Override
    public final boolean removable(Var v) {
        return this.root.removable(v) && super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        VarUsage inPreds = super.count(v);
        VarUsage inRoot = this.root.count(v);
        if (inPreds == VarUsage.NEVER) {
            return inRoot;
        }
        long sz = this.root.size();
        return sz >= 0L && sz <= 1L || this.root.type().zeroOrOne() ? inRoot.plus(inPreds) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr rt;
        boolean pr = super.inline(ctx, scp, v, e) != null;
        Expr expr = rt = this.root == null ? null : this.root.inline(ctx, scp, v, e);
        if (rt != null) {
            this.root = rt;
        }
        return pr || rt != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public final void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        this.addPlan(plan, el, this.root);
        super.plan(el);
    }

    @Override
    public final String toString() {
        return this.root + super.toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr e : this.preds) {
            visitor.enterFocus();
            if (!e.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return this.root.accept(visitor);
    }

    @Override
    public final int exprSize() {
        int sz = 1;
        for (Expr e : this.preds) {
            sz += e.exprSize();
        }
        return sz + this.root.exprSize();
    }
}

