/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Treat
extends Single {
    public Treat(InputInfo ii, Expr e, SeqType s) {
        super(ii, e);
        this.type = s;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        return this.expr.isValue() ? this.optPre(this.value(ctx), ctx) : this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        final Iter iter = ctx.iter(this.expr);
        final Item it = iter.next();
        if (it == null) {
            if (this.type.mayBeZero()) {
                return Empty.ITER;
            }
            throw Err.NOTREAT.get(this.info, this.description(), Empty.SEQ, this.type);
        }
        if (this.type.occ == SeqType.Occ.ZERO) {
            throw Err.NOTREAT.get(this.info, this.description(), it.type, this.type);
        }
        if (this.type.zeroOrOne()) {
            if (iter.next() != null) {
                throw Err.NOTREATS.get(this.info, this.description(), this.type);
            }
            if (!it.type.instanceOf(this.type.type)) {
                throw Err.NOTREAT.get(this.info, this.description(), it.type, this.type);
            }
            return it.iter();
        }
        return new Iter(){
            Item i;
            {
                this.i = it;
            }

            @Override
            public Item next() throws QueryException {
                if (this.i == null) {
                    return null;
                }
                if (!this.i.type.instanceOf(Treat.this.type.type)) {
                    throw Err.NOTREAT.get(Treat.this.info, Treat.this.description(), this.i.type, Treat.this.type);
                }
                Item ii = this.i;
                this.i = iter.next();
                return ii;
            }
        };
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        Value val = ctx.value(this.expr);
        long len = val.size();
        if (len == 0L) {
            if (this.type.mayBeZero()) {
                return val;
            }
            throw Err.NOTREAT.get(this.info, this.description(), Empty.SEQ, this.type);
        }
        if (this.type.occ == SeqType.Occ.ZERO) {
            throw Err.NOTREAT.get(this.info, this.description(), val.type, this.type);
        }
        if (this.type.zeroOrOne()) {
            if (len > 1L) {
                throw Err.NOTREATS.get(this.info, this.description(), this.type);
            }
            Item it = val.itemAt(0L);
            if (!it.type.instanceOf(this.type.type)) {
                throw Err.NOTREAT.get(this.info, this.description(), it.type, this.type);
            }
            return it;
        }
        for (long i = 0L; i < len; ++i) {
            Item it = val.itemAt(i);
            if (it.type.instanceOf(this.type.type)) continue;
            throw Err.NOTREAT.get(this.info, this.description(), it.type, this.type);
        }
        return val;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Treat(this.info, this.expr.copy(ctx, scp, vs), this.type);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.TYP, this.type), this.expr);
    }

    @Override
    public String toString() {
        return '(' + this.expr.toString() + ") " + "treat" + ' ' + "as" + ' ' + this.type;
    }
}

