/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTMatches;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTOr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTAnd
extends FTExpr {
    private boolean[] neg;

    public FTAnd(InputInfo ii, FTExpr[] e) {
        super(ii, e);
    }

    @Override
    public FTExpr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        boolean not = true;
        for (FTExpr e : this.expr) {
            not &= e instanceof FTNot;
        }
        if (not) {
            int es = this.expr.length;
            for (int e = 0; e < es; ++e) {
                this.expr[e] = this.expr[e].expr[0];
            }
            return new FTNot(this.info, (FTExpr)new FTOr(this.info, this.expr));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        FTNode item = this.expr[0].item(ctx, this.info);
        int es = this.expr.length;
        for (int e = 1; e < es; ++e) {
            FTAnd.and(item, this.expr[e].item(ctx, this.info));
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext ctx) throws QueryException {
        int es = this.expr.length;
        final FTIter[] ir = new FTIter[es];
        final FTNode[] it = new FTNode[es];
        for (int e = 0; e < es; ++e) {
            ir[e] = this.expr[e].iter(ctx);
            it[e] = ir[e].next();
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                for (int i = 0; i < it.length; ++i) {
                    if (it[i] == null) {
                        if (FTAnd.this.neg[i]) continue;
                        return null;
                    }
                    int d = it[0].pre - it[i].pre;
                    if (FTAnd.this.neg[i]) {
                        if (d < 0) continue;
                        if (d == 0) {
                            it[0] = ir[0].next();
                        }
                        it[i] = ir[i].next();
                        i = -1;
                        continue;
                    }
                    if (d == 0) continue;
                    if (d < 0) {
                        i = 0;
                    }
                    it[i] = ir[i].next();
                    i = -1;
                }
                FTNode item = it[0];
                for (int i = 1; i < it.length; ++i) {
                    if (FTAnd.this.neg[i]) continue;
                    FTAnd.and(item, it[i]);
                    it[i] = ir[i].next();
                }
                it[0] = ir[0].next();
                return item;
            }
        };
    }

    private static void and(FTNode i1, FTNode i2) {
        FTMatches all = new FTMatches((byte)Math.max(i1.all.pos, i2.all.pos));
        for (FTMatch s1 : i1.all) {
            for (FTMatch s2 : i2.all) {
                all.add(new FTMatch(s1.size() + s2.size()).add(s1).add(s2));
            }
        }
        i1.score(Scoring.merge(i1.score(), i2.score()));
        i1.all = all;
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) throws QueryException {
        int es = this.expr.length;
        this.neg = new boolean[es];
        int is = 0;
        int n = 0;
        for (int i = 0; i < es; ++i) {
            if (!this.expr[i].indexAccessible(ic)) {
                return false;
            }
            this.neg[i] = ic.not;
            if (ic.not) {
                ++n;
            }
            ic.not = false;
            if (is == 0 || ic.costs() < is) {
                is = ic.costs();
            }
            if (ic.costs() == 0) break;
        }
        ic.costs(is);
        return !this.neg[0] && n < es;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        FTAnd copy = new FTAnd(this.info, (FTExpr[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
        if (this.neg != null) {
            copy.neg = (boolean[])this.neg.clone();
        }
        return copy;
    }

    @Override
    public String toString() {
        return "(" + this.toString(" ftand ") + ")";
    }
}

