/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class FTWeight
extends FTExpr {
    private Expr weight;

    public FTWeight(InputInfo ii, FTExpr e, Expr w) {
        super(ii, e);
        this.weight = w;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.weight);
        super.checkUp();
    }

    @Override
    public FTExpr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.weight = this.weight.compile(ctx, scp);
        return super.compile(ctx, scp);
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.weight(this.expr[0].item(ctx, this.info), ctx);
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                return FTWeight.this.weight(FTWeight.this.expr[0].iter(ctx).next(), ctx);
            }
        };
    }

    private FTNode weight(FTNode item, QueryContext ctx) throws QueryException {
        if (item == null) {
            return null;
        }
        double d = this.checkDbl(this.weight, ctx);
        if (Math.abs(d) > 1000.0) {
            throw Err.FTWEIGHT.get(this.info, d);
        }
        if (d == 0.0) {
            item.all.size(0);
        }
        item.score(item.score() * d);
        return item;
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) {
        return false;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.weight.has(flag) || super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.weight.removable(v) && super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.weight.count(v).plus(super.count(v));
    }

    @Override
    public FTExpr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = FTWeight.inlineAll(ctx, scp, this.expr, v, e);
        Expr w = this.weight.inline(ctx, scp, v, e);
        if (w != null) {
            this.weight = w;
            change = true;
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTWeight(this.info, (FTExpr)this.expr[0].copy(ctx, scp, (IntObjMap)vs), this.weight.copy(ctx, scp, vs));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.weight, this.expr[0]);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.weight.accept(visitor);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (FTExpr e : this.expr) {
            sz += e.exprSize();
        }
        return sz + this.weight.exprSize();
    }

    @Override
    public String toString() {
        return this.expr[0] + " " + "weight" + ' ' + this.weight;
    }
}

