/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTWindow
extends FTFilter {
    private Expr win;

    public FTWindow(InputInfo ii, FTExpr e, Expr w, FTUnit u) {
        super(ii, e, u);
        this.win = w;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.win);
        super.checkUp();
    }

    @Override
    public FTExpr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.win = this.win.compile(ctx, scp);
        return super.compile(ctx, scp);
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) throws QueryException {
        int n = (int)this.checkItr(this.win, ctx) - 1;
        mtc.sort();
        FTStringMatch f = null;
        for (FTStringMatch m : mtc) {
            if (m.exclude) continue;
            if (f == null) {
                f = m;
            }
            f.gaps = f.gaps | m.end - f.end > 1;
            f.end = m.end;
            if (this.pos(f.end, lex) - this.pos(f.start, lex) <= n) continue;
            return false;
        }
        if (f == null) {
            return false;
        }
        int w = n - this.pos(f.end, lex) + this.pos(f.start, lex);
        for (int s = this.pos(f.start, lex) - w; s <= this.pos(f.start, lex); ++s) {
            boolean h = false;
            for (FTStringMatch m : mtc) {
                h = m.exclude && this.pos(m.start, lex) >= s && this.pos(m.end, lex) <= s + w;
                if (!h) continue;
                break;
            }
            if (h) continue;
            mtc.reset();
            mtc.add(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.win.has(flag) || super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.win.removable(v) && super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.win.count(v).plus(super.count(v));
    }

    @Override
    public FTExpr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean ex = FTWindow.inlineAll(ctx, scp, this.expr, v, e);
        Expr w = this.win.inline(ctx, scp, v, e);
        if (w != null) {
            this.win = w;
        }
        return ex || w != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTWindow(this.info, (FTExpr)this.expr[0].copy(ctx, scp, (IntObjMap)vs), this.win.copy(ctx, scp, vs), this.unit);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{"window", this.unit}), new Object[]{this.win, this.expr});
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.win.accept(visitor);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (FTExpr e : this.expr) {
            sz += e.exprSize();
        }
        return sz + this.win.exprSize();
    }

    @Override
    public String toString() {
        return super.toString() + "window" + ' ' + this.win + ' ' + (Object)((Object)this.unit);
    }
}

