/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.Nodes;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.Err;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class Thesaurus {
    private final TokenObjMap<ThesNode> nodes = new TokenObjMap();
    private static final TokenMap RSHIPS = new TokenMap();
    private final Context ctx;
    private final IO file;
    private final byte[] rel;
    private final long min;
    private final long max;

    public Thesaurus(IO fl, Context c) {
        this(fl, Token.EMPTY, 0L, Long.MAX_VALUE, c);
    }

    public Thesaurus(IO fl, byte[] rs, long mn, long mx, Context c) {
        this.file = fl;
        this.rel = rs;
        this.min = mn;
        this.max = mx;
        this.ctx = c;
    }

    private void init(InputInfo ii) throws QueryException {
        try {
            MemData data = MemBuilder.build(Parser.xmlParser(this.file, this.ctx.options));
            Nodes result = this.nodes("//*:entry", new Nodes(0, (Data)data));
            int n = 0;
            while ((long)n < result.size()) {
                this.build(new Nodes(result.pres[n], (Data)data));
                ++n;
            }
        }
        catch (IOException ex) {
            throw Err.NOTHES.get(ii, this.file);
        }
    }

    private void build(Nodes in) throws QueryException {
        Nodes sub = this.nodes("*:synonym", in);
        if (sub.size() == 0L) {
            return;
        }
        ThesNode node = this.node(this.text("*:term", in));
        int n = 0;
        while ((long)n < sub.size()) {
            Nodes tmp = new Nodes(sub.pres[n], sub.data);
            ThesNode snode = this.node(this.text("*:term", tmp));
            byte[] rs = this.text("*:relationship", tmp);
            node.add(snode, rs);
            byte[] srs = RSHIPS.get(rs);
            if (srs != null) {
                snode.add(node, srs);
            }
            this.build(sub);
            ++n;
        }
    }

    private ThesNode node(byte[] term) {
        ThesNode node = this.nodes.get(term);
        if (node == null) {
            node = new ThesNode();
            node.term = term;
            this.nodes.put(term, node);
        }
        return node;
    }

    private Nodes nodes(String query, Nodes in) throws QueryException {
        return new QueryProcessor(query, this.ctx).context(in).queryNodes();
    }

    private byte[] text(String query, Nodes in) throws QueryException {
        return new QueryProcessor(query, this.ctx).context(in).iter().next().string(null);
    }

    void find(InputInfo ii, TokenList list, byte[] ft) throws QueryException {
        if (this.nodes.isEmpty()) {
            this.init(ii);
        }
        this.find(list, this.nodes.get(ft), 1L);
    }

    private void find(TokenList list, ThesNode node, long lev) {
        if (lev > this.max || node == null) {
            return;
        }
        for (int n = 0; n < node.size; ++n) {
            byte[] term;
            if (this.rel.length != 0 && !Token.eq(node.rs[n], this.rel) || list.contains(term = node.nodes[n].term)) continue;
            list.add(term);
            this.find(list, node.nodes[n], lev + 1L);
        }
    }

    boolean sameAs(Thesaurus th) {
        return this.file.eq(th.file) && this.min == th.min && this.max == th.max && Token.eq(this.rel, th.rel);
    }

    static {
        RSHIPS.put("NT", "BT");
        RSHIPS.put("BT", "BT");
        RSHIPS.put("BTG", "NTG");
        RSHIPS.put("NTG", "BTG");
        RSHIPS.put("BTP", "NTP");
        RSHIPS.put("NTP", "BTP");
        RSHIPS.put("USE", "UF");
        RSHIPS.put("UF", "USE");
        RSHIPS.put("RT", "RT");
    }

    static class ThesNode {
        ThesNode[] nodes = new ThesNode[1];
        byte[][] rs = new byte[1][];
        byte[] term;
        int size;

        ThesNode() {
        }

        void add(ThesNode n, byte[] r) {
            if (this.size == this.nodes.length) {
                int s = Array.newSize(this.size);
                this.nodes = Array.copy(this.nodes, new ThesNode[s]);
                this.rs = Array.copyOf(this.rs, s);
            }
            this.nodes[this.size] = n;
            this.rs[this.size++] = r;
        }
    }
}

