/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNHash
extends StandardFunc {
    public FNHash(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _HASH_MD5: {
                return this.hash("MD5", ctx);
            }
            case _HASH_SHA1: {
                return this.hash("SHA", ctx);
            }
            case _HASH_SHA256: {
                return this.hash("SHA-256", ctx);
            }
            case _HASH_HASH: {
                return this.hash(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 hash(QueryContext ctx) throws QueryException {
        return this.hash(Token.string(this.checkStr(this.expr[1], ctx)), ctx);
    }

    private B64 hash(String algo, QueryContext ctx) throws QueryException {
        return this.hashBinary(this.checkStrBin(this.checkItem(this.expr[0], ctx)), algo);
    }

    private B64 hashBinary(byte[] val, String algo) throws QueryException {
        try {
            return new B64(MessageDigest.getInstance(algo).digest(val));
        }
        catch (NoSuchAlgorithmException ex) {
            throw Err.HASH_ALG.get(this.info, algo);
        }
    }
}

