/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class FNProc
extends StandardFunc {
    private static final String RESULT = "result";
    private static final String OUTPUT = "output";
    private static final String ERROR = "error";
    private static final String CODE = "code";

    public FNProc(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Charset cs;
        this.checkCreate(ctx);
        TokenList tl = new TokenList();
        tl.add(this.checkStr(this.expr[0], ctx));
        if (this.expr.length > 1) {
            Item it;
            Iter ir = ctx.iter(this.expr[1]);
            while ((it = ir.next()) != null) {
                tl.add(this.checkStr(it));
            }
        }
        String c = this.expr.length > 2 ? Token.string(this.checkStr(this.expr[2], ctx)) : Prop.ENCODING;
        try {
            cs = Charset.forName(c);
        }
        catch (Exception ex) {
            throw Err.BXPR_ENC.get(this.info, c);
        }
        String[] args = tl.toStringArray();
        switch (this.sig) {
            case _PROC_SYSTEM: {
                return this.system(args, cs);
            }
            case _PROC_EXECUTE: {
                return FNProc.execute(args, cs);
            }
        }
        return super.item(ctx, ii);
    }

    private Str system(String[] args, Charset cs) throws QueryException {
        Result result = FNProc.exec(args, cs);
        if (result.code == 0) {
            return Str.get(FNProc.norm(result.output));
        }
        QNm name = new QNm("PROC" + String.format("%04d", result.code));
        throw new QueryException(this.info, name, Token.string(FNProc.norm(result.error)), new Object[0]);
    }

    private static FElem execute(String[] args, Charset cs) {
        Result result = FNProc.exec(args, cs);
        FElem root = new FElem(RESULT);
        root.add(new FElem(OUTPUT).add(FNProc.norm(result.output)));
        root.add(new FElem(ERROR).add(FNProc.norm(result.error)));
        root.add(new FElem(CODE).add(Token.token(result.code)));
        return root;
    }

    private static Result exec(String[] args, Charset cs) {
        Process proc;
        Result result = new Result();
        try {
            proc = new ProcessBuilder(args).start();
        }
        catch (IOException ex) {
            result.error.add(Util.message(ex));
            result.code = 9999;
            return result;
        }
        try {
            Thread outt = FNProc.reader(proc.getInputStream(), result.output, cs);
            Thread errt = FNProc.reader(proc.getErrorStream(), result.error, cs);
            outt.start();
            errt.start();
            proc.waitFor();
            outt.join();
            errt.join();
        }
        catch (InterruptedException ex) {
            result.error.add(Util.message(ex));
        }
        result.code = proc.exitValue();
        return result;
    }

    private static Thread reader(InputStream in, final TokenBuilder tb, Charset cs) {
        InputStreamReader isr = new InputStreamReader(in, cs);
        final BufferedReader br = new BufferedReader(isr);
        return new Thread(){

            @Override
            public void run() {
                try {
                    int b;
                    while ((b = br.read()) != -1) {
                        tb.add(b);
                    }
                }
                catch (IOException ex) {
                    Util.stack(ex);
                }
            }
        };
    }

    private static byte[] norm(TokenBuilder tb) {
        return Token.delete(tb.finish(), 13);
    }

    static class Result {
        final TokenBuilder output = new TokenBuilder();
        final TokenBuilder error = new TokenBuilder();
        int code;

        Result() {
        }
    }
}

