/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrStream;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FNStream
extends StandardFunc {
    public FNStream(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _STREAM_MATERIALIZE: {
                return this.materialize(ctx);
            }
            case _STREAM_IS_STREAMABLE: {
                return this.isStreamable(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item materialize(QueryContext ctx) throws QueryException {
        return this.checkItem(this.expr[0], ctx).materialize(this.info);
    }

    private Item isStreamable(QueryContext ctx) throws QueryException {
        Item it = this.checkItem(this.expr[0], ctx);
        return Bln.get(it instanceof StrStream || it instanceof B64Stream);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        if (this.sig == Function._STREAM_MATERIALIZE) {
            this.type = this.expr[0].type();
        }
        return this;
    }
}

