/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.ProcException;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class FNXQuery
extends StandardFunc {
    private static final String PREFIX = "xquery";
    private static final QNm Q_OPTIONS = QNm.get("xquery", "options", QueryText.XQUERYURI);

    public FNXQuery(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _XQUERY_EVAL: {
                return this.eval(ctx, true);
            }
            case _XQUERY_EVALUATE: {
                return this.eval(ctx, false);
            }
            case _XQUERY_INVOKE: {
                return this.invoke(ctx);
            }
            case _XQUERY_TYPE: {
                return this.value(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _XQUERY_EVAL: {
                return this.eval(ctx, true).value();
            }
            case _XQUERY_EVALUATE: {
                return this.eval(ctx, false).value();
            }
            case _XQUERY_INVOKE: {
                return this.invoke(ctx).value();
            }
            case _XQUERY_TYPE: {
                return this.type(ctx).value(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        return this.sig == Function._XQUERY_TYPE ? this.type(ctx) : this;
    }

    private ValueBuilder eval(QueryContext ctx, boolean openDB) throws QueryException {
        return this.eval(ctx, this.checkStr(this.expr[0], ctx), null, openDB);
    }

    private ValueBuilder eval(QueryContext ctx, byte[] qu, String path, boolean openDB) throws QueryException {
        HashMap<String, Value> bindings = this.bindings(1, ctx);
        final QueryContext qc = ctx.proc(new QueryContext(ctx));
        qc.resource.openDB = openDB;
        Timer to = new Timer(true);
        Perm tmp = ctx.context.user.perm;
        if (this.expr.length > 2) {
            long ms;
            XQueryOptions opts = this.checkOptions(2, Q_OPTIONS, new XQueryOptions(), ctx);
            ctx.context.user.perm = Perm.get(opts.get(XQueryOptions.PERMISSION));
            Performance.gc(2);
            long mb = opts.get(XQueryOptions.MEMORY).intValue();
            if (mb != 0L) {
                final long limit = Performance.memory() + (mb << 20);
                to.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (Performance.memory() > limit) {
                            Performance.gc(1);
                            if (Performance.memory() > limit) {
                                qc.stop();
                            }
                        }
                    }
                }, 500L, 500L);
            }
            if ((ms = (long)opts.get(XQueryOptions.TIMEOUT).intValue() * 1000L) != 0L) {
                to.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        qc.stop();
                    }
                }, ms);
            }
        }
        try {
            StaticContext sctx = new StaticContext(qc.context.options.get(MainOptions.XQUERY3));
            for (Map.Entry<String, Value> it : bindings.entrySet()) {
                String k = it.getKey();
                Value v = it.getValue();
                if (k.isEmpty()) {
                    qc.context(v, null, sctx);
                    continue;
                }
                qc.bind(k, v, null);
            }
            qc.parseMain(Token.string(qu), path, sctx);
            if (qc.updating) {
                throw Err.BXXQ_UPDATING.get(this.info, new Object[0]);
            }
            qc.compile();
            ValueBuilder vb = new ValueBuilder();
            Iter iter = qc.iter();
            if (openDB) {
                this.cache(iter, vb, ctx);
            } else {
                Item it;
                while ((it = iter.next()) != null) {
                    if (it instanceof FItem) {
                        throw Err.FIVALUE.get(this.info, it.type);
                    }
                    vb.add(it);
                }
            }
            ValueBuilder valueBuilder = vb;
            return valueBuilder;
        }
        catch (ProcException ex) {
            throw Err.BXXQ_STOPPED.get(this.info, new Object[0]);
        }
        catch (QueryException ex) {
            throw ex.err() == Err.BASX_PERM ? Err.BXXQ_PERM.get(this.info, ex.getLocalizedMessage()) : ex;
        }
        finally {
            ctx.context.user.perm = tmp;
            ctx.proc(null);
            qc.close();
            to.cancel();
        }
    }

    private ValueBuilder invoke(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        IO io = this.checkPath(this.expr[0], ctx);
        try {
            return this.eval(ctx, io.read(), io.path(), true);
        }
        catch (IOException ex) {
            throw Err.IOERR.get(this.info, ex);
        }
    }

    private Expr type(QueryContext ctx) {
        FNInfo.dump(Util.inf("{ type: %, size: %, exprSize: % }", this.expr[0].type(), this.expr[0].size(), this.expr[0].exprSize()), Token.token(this.expr[0].toString()), ctx);
        return this.expr[0];
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return (!FNXQuery.oneOf(this.sig, Function._XQUERY_EVAL, Function._XQUERY_INVOKE) || visitor.lock(null)) && super.accept(visitor);
    }

    public static class XQueryOptions
    extends Options {
        public static final StringOption PERMISSION = new StringOption("permission", Perm.ADMIN.name());
        public static final NumberOption TIMEOUT = new NumberOption("timeout", 0);
        public static final NumberOption MEMORY = new NumberOption("memory", 0);
    }
}

