/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.FNInfo;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.TypedFunc;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class FuncLit
extends Single
implements Scope {
    private final VarScope scope;
    private final StaticContext sc;
    private Ann ann;
    private final QNm name;
    private final Var[] args;
    private final boolean check;
    private boolean compiled;

    public FuncLit(Ann a, QNm nm, Var[] arg, Expr fn, FuncType ft, VarScope scp, StaticContext sctx, InputInfo ii) {
        super(ii, fn);
        this.ann = a;
        this.name = nm;
        this.args = arg;
        this.check = ft == null;
        this.type = (ft == null ? FuncType.arity(this.args.length) : ft).seqType();
        this.scope = scp;
        this.sc = sctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(QueryContext ctx) throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        if (this.check) {
            StaticFunc sf = ctx.funcs.get(this.name, this.args.length, this.info, true);
            if (sf == null) {
                throw Err.FUNCUNKNOWN.get(this.info, new Object[]{this.name.string()});
            }
            this.ann = sf.ann;
            this.type = sf.funcType().seqType();
        }
        try {
            this.expr = this.expr.compile(ctx, this.scope);
            this.expr.markTailCalls(null);
        }
        catch (QueryException e) {
            this.expr = FNInfo.error(e, this.type);
        }
        finally {
            this.scope.cleanUp(this);
        }
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope o) throws QueryException {
        this.compile(ctx);
        return this.expr.isValue() ? this.preEval(ctx) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) {
        return new FuncItem(this.sc, this.ann == null ? new Ann() : this.ann, this.name, this.args, (FuncType)this.type.type, this.expr, ctx.value, ctx.pos, ctx.size, this.scope.stackSize());
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope o, IntObjMap<Var> vs) {
        Ann a;
        Ann ann = a = this.ann == null ? null : new Ann();
        if (a != null) {
            for (int i = 0; i < this.ann.size(); ++i) {
                a.add(this.ann.names[i], this.ann.values[i], this.info);
            }
        }
        VarScope scp = new VarScope(this.sc);
        Var[] arg = new Var[this.args.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = scp.newCopyOf(ctx, this.args[i]);
            vs.put(this.args[i].id, arg[i]);
        }
        Expr call = this.expr.copy(ctx, scp, vs);
        return new FuncLit(a, this.name, arg, call, (FuncType)this.type.type, scp, this.sc, this.info);
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.CTX || flag == Expr.Flag.FCS;
    }

    public static FuncLit unknown(QNm nm, long ar, QueryContext ctx, StaticContext sctx, InputInfo ii) throws QueryException {
        VarScope scp = new VarScope(sctx);
        Var[] arg = new Var[(int)ar];
        Expr[] refs = new Expr[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = scp.newLocal(ctx, new QNm("arg" + (i + 1), ""), SeqType.ITEM_ZM, true);
            refs[i] = new VarRef(ii, arg[i]);
        }
        TypedFunc call = ctx.funcs.getFuncRef(nm, refs, sctx, ii);
        return new FuncLit(null, nm, arg, call.fun, null, scp, sctx, ii);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var v : this.args) {
            if (visitor.declared(v)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.inlineFunc(this);
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.string()).add(35).addExt(this.args.length, new Object[0]).toString();
    }
}

