/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.func.JavaModuleFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JavaMapping
extends Arr {
    static final String NEW = "new";
    private static final Class<?>[] JAVA = new Class[]{String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class, QName.class, Character.TYPE, Character.class, URI.class, URL.class};
    private static final Type[] XQUERY = new Type[]{AtomType.STR, AtomType.BLN, AtomType.BLN, AtomType.BYT, AtomType.BYT, AtomType.SHR, AtomType.SHR, AtomType.INT, AtomType.INT, AtomType.LNG, AtomType.LNG, AtomType.FLT, AtomType.FLT, AtomType.DBL, AtomType.DBL, AtomType.DEC, AtomType.ITR, AtomType.QNM, AtomType.STR, AtomType.STR, AtomType.URI, AtomType.URI};
    final StaticContext sc;

    JavaMapping(StaticContext sctx, InputInfo ii, Expr[] a) {
        super(ii, a);
        this.sc = sctx;
    }

    @Override
    public final Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public final Value value(QueryContext ctx) throws QueryException {
        int es = this.expr.length;
        Value[] args = new Value[es];
        for (int e = 0; e < es; ++e) {
            args[e] = ctx.value(this.expr[e]);
        }
        return JavaMapping.toValue(this.eval(args, ctx), ctx, this.sc);
    }

    protected abstract Object eval(Value[] var1, QueryContext var2) throws QueryException;

    public static Value toValue(Object obj, QueryContext ctx, StaticContext sc) throws QueryException {
        if (obj == null) {
            return Empty.SEQ;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (obj instanceof Iter) {
            return ((Iter)obj).value();
        }
        Type type = JavaMapping.type(obj);
        if (type != null) {
            return type.cast(obj, ctx, sc, null);
        }
        if (obj instanceof byte[]) {
            return BytSeq.get((byte[])obj);
        }
        if (obj instanceof long[]) {
            return IntSeq.get((long[])obj, AtomType.ITR);
        }
        if (obj instanceof char[]) {
            return Str.get(new String((char[])obj));
        }
        if (obj instanceof boolean[]) {
            return BlnSeq.get((boolean[])obj);
        }
        if (obj instanceof double[]) {
            return DblSeq.get((double[])obj);
        }
        if (obj instanceof float[]) {
            return FltSeq.get((float[])obj);
        }
        if (!obj.getClass().isArray()) {
            return new Jav(obj, ctx);
        }
        int s = Array.getLength(obj);
        if (s == 0) {
            return Empty.SEQ;
        }
        if (obj instanceof String[]) {
            String[] r = (String[])obj;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(r[v]);
            }
            return StrSeq.get(b);
        }
        if (obj instanceof char[][]) {
            char[][] r = (char[][])obj;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(new String(r[v]));
            }
            return StrSeq.get(b);
        }
        if (obj instanceof short[]) {
            short[] r = (short[])obj;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.SHR);
        }
        if (obj instanceof int[]) {
            int[] r = (int[])obj;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.INT);
        }
        Object[] objs = (Object[])obj;
        ValueBuilder vb = new ValueBuilder(objs.length);
        for (Object o : objs) {
            vb.add(JavaMapping.toValue(o, ctx, sc));
        }
        return vb.value();
    }

    private static Method getModMethod(Object mod, String path, String name, long arity, QueryContext ctx, InputInfo ii) throws QueryException {
        Method meth = null;
        for (Method m : mod.getClass().getMethods()) {
            if (!m.getName().equals(name) || (long)m.getParameterTypes().length != arity) continue;
            if (meth != null) {
                throw Err.JAVAAMBIG.get(ii, "Q{" + path + '}' + name + '#' + arity);
            }
            meth = m;
        }
        if (meth == null) {
            throw Err.FUNCJAVA.get(ii, path + ':' + name);
        }
        Perm perm = Perm.ADMIN;
        QueryModule.Requires req = meth.getAnnotation(QueryModule.Requires.class);
        if (req != null) {
            perm = Perm.get(req.value().name());
        }
        if (!ctx.context.user.has(perm)) {
            return null;
        }
        QueryModule.Lock lock = meth.getAnnotation(QueryModule.Lock.class);
        if (lock != null) {
            for (String read : lock.read()) {
                ctx.readLocks.add("&" + read);
            }
            for (String write : lock.write()) {
                ctx.writeLocks.add("&" + write);
            }
        }
        return meth;
    }

    private static String toPath(byte[] uri) {
        String path = Token.string(uri);
        String p = ModuleLoader.uri2path(path);
        return p == null ? path : ModuleLoader.capitalize(p).replace("/", ".").substring(1);
    }

    static JavaMapping get(QNm qname, Expr[] args, QueryContext ctx, StaticContext sctx, InputInfo ii) throws QueryException {
        Method meth;
        byte[] uri = qname.uri();
        boolean java = Token.startsWith(uri, QueryText.JAVAPREF);
        String name = Token.camelCase(Token.string(qname.local()));
        String path = Token.camelCase(JavaMapping.toPath(java ? Token.substring(uri, QueryText.JAVAPREF.length) : uri));
        ModuleLoader modules = ctx.modules();
        Object jm = modules.findImport(path);
        if (jm != null && (meth = JavaMapping.getModMethod(jm, path, name, args.length, ctx, ii)) != null) {
            return new JavaModuleFunc(sctx, ii, jm, meth, args);
        }
        if (!ctx.context.user.has(Perm.ADMIN)) {
            return null;
        }
        try {
            return new JavaFunc(sctx, ii, modules.findClass(path), name, args);
        }
        catch (ClassNotFoundException ex) {
            if (java) {
                throw Err.FUNCJAVA.get(ii, path);
            }
        }
        catch (Throwable th) {
            throw Err.JAVAINIT.get(ii, th);
        }
        return null;
    }

    private static Type type(Object o) {
        Type t = JavaMapping.type(o.getClass());
        if (t != null) {
            return t;
        }
        if (o instanceof Element) {
            return NodeType.ELM;
        }
        if (o instanceof Document) {
            return NodeType.DOC;
        }
        if (o instanceof DocumentFragment) {
            return NodeType.DOC;
        }
        if (o instanceof Attr) {
            return NodeType.ATT;
        }
        if (o instanceof Comment) {
            return NodeType.COM;
        }
        if (o instanceof ProcessingInstruction) {
            return NodeType.PI;
        }
        if (o instanceof Text) {
            return NodeType.TXT;
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return !d.isSet(DatatypeConstants.YEARS) && !d.isSet(DatatypeConstants.MONTHS) ? AtomType.DTD : (!d.isSet(DatatypeConstants.HOURS) && !d.isSet(DatatypeConstants.MINUTES) && !d.isSet(DatatypeConstants.SECONDS) ? AtomType.YMD : AtomType.DUR);
        }
        if (o instanceof XMLGregorianCalendar) {
            QName type = ((XMLGregorianCalendar)o).getXMLSchemaType();
            if (type == DatatypeConstants.DATE) {
                return AtomType.DAT;
            }
            if (type == DatatypeConstants.DATETIME) {
                return AtomType.DTM;
            }
            if (type == DatatypeConstants.TIME) {
                return AtomType.TIM;
            }
            if (type == DatatypeConstants.GYEARMONTH) {
                return AtomType.YMO;
            }
            if (type == DatatypeConstants.GMONTHDAY) {
                return AtomType.MDA;
            }
            if (type == DatatypeConstants.GYEAR) {
                return AtomType.YEA;
            }
            if (type == DatatypeConstants.GMONTH) {
                return AtomType.MON;
            }
            if (type == DatatypeConstants.GDAY) {
                return AtomType.DAY;
            }
        }
        return null;
    }

    static Type type(Class<?> type) {
        for (int j = 0; j < JAVA.length; ++j) {
            if (JAVA[j] != type) continue;
            return XQUERY[j];
        }
        return null;
    }

    static String foundArgs(Value[] args) {
        StringBuilder sb = new StringBuilder();
        for (Value v : args) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(v instanceof Jav ? Util.className(((Jav)v).toJava()) : v.type());
        }
        return sb.toString();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.NDT || super.has(flag);
    }
}

