/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.basex.core.Databases;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryResources;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.QueryInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.options.Options;

public abstract class StandardFunc
extends Arr {
    Function sig;
    final StaticContext sc;

    protected StandardFunc(StaticContext sctx, InputInfo ii, Function s, Expr ... args) {
        super(ii, args);
        this.sc = sctx;
        this.sig = s;
        this.type = this.sig.ret;
    }

    @Override
    public final Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public final Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        return this.optPre(this.has(Expr.Flag.CTX) || this.has(Expr.Flag.NDT) || this.has(Expr.Flag.HOF) || !this.allAreValues() ? this.opt(ctx, scp) : (this.sig.ret.zeroOrOne() ? this.item(ctx, this.info) : this.value(ctx)), ctx);
    }

    Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        return this;
    }

    @Override
    public final StandardFunc copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        int es = this.expr.length;
        Expr[] arg = new Expr[es];
        for (int e = 0; e < es; ++e) {
            arg[e] = this.expr[e].copy(ctx, scp, vs);
        }
        return this.sig.get(this.sc, this.info, arg);
    }

    public static Item atom(Item it, InputInfo ii) throws QueryException {
        Type ip = it.type;
        return it instanceof ANode ? (ip == NodeType.PI || ip == NodeType.COM ? Str.get(it.string(ii)) : new Atm(it.string(ii))) : it.materialize(ii);
    }

    byte[] serialize(Iter ir, SerializerOptions opts, Err err) throws QueryException {
        ArrayOutput ao = new ArrayOutput();
        try {
            Item it;
            Serializer ser = Serializer.get(ao, opts);
            while ((it = ir.next()) != null) {
                ser.serialize(it);
            }
            ser.close();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw err.get(this.info, ex);
        }
        return ao.toArray();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.sig.has(flag) || flag != Expr.Flag.X30 && flag != Expr.Flag.HOF && super.has(flag);
    }

    @Override
    public final boolean isFunction(Function f) {
        return this.sig == f;
    }

    @Override
    public final boolean isVacuous() {
        return !this.has(Expr.Flag.UPD) && this.type.eq(SeqType.EMP);
    }

    @Override
    public final String description() {
        return this.sig.toString();
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.sig.desc), this.expr);
    }

    @Override
    public final String toString() {
        String desc = this.sig.toString();
        return new TokenBuilder(desc.substring(0, desc.indexOf(40) + 1)).addSep(this.expr, ", ").add(")").toString();
    }

    final Data checkData(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.INVDB.get(this.info, name);
        }
        return ctx.resource.database(name, this.info);
    }

    File checkFile(int i, QueryContext ctx) throws QueryException {
        if (i >= this.expr.length) {
            return null;
        }
        String file = Token.string(this.checkStr(this.expr[i], ctx));
        return IOUrl.isFileURL(file) ? IOFile.get(file).file() : new File(file);
    }

    IO checkPath(Expr path, QueryContext ctx) throws QueryException {
        return QueryResources.checkPath(new QueryInput(Token.string(this.checkStr(path, ctx))), this.sc.baseIO(), this.info);
    }

    final boolean dataLock(ASTVisitor visitor) {
        return visitor.lock(this.expr[0] instanceof Str ? Token.string(((Str)this.expr[0]).string()) : null);
    }

    final String encoding(int i, Err err, QueryContext ctx) throws QueryException {
        if (i >= this.expr.length) {
            return null;
        }
        String enc = Token.string(this.checkStr(this.expr[i], ctx));
        try {
            if (Charset.isSupported(enc)) {
                return Token.normEncoding(enc);
            }
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        throw err.get(this.info, enc);
    }

    <E extends Options> E checkOptions(int i, QNm qnm, E opts, QueryContext ctx) throws QueryException {
        if (i < this.expr.length) {
            new FuncOptions(qnm, this.info).parse(this.expr[i].item(ctx, this.info), opts);
        }
        return opts;
    }

    final long dateTimeToMs(Expr e, QueryContext ctx) throws QueryException {
        Dtm dtm = (Dtm)this.checkType(this.checkItem(e, ctx), AtomType.DTM);
        if (dtm.yea() > 292278993L) {
            throw Err.INTRANGE.get(this.info, dtm);
        }
        return dtm.toJava().toGregorianCalendar().getTimeInMillis();
    }

    final HashMap<String, Value> bindings(int i, QueryContext ctx) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        int es = this.expr.length;
        if (i < es) {
            Map map = this.checkMap(this.checkItem(this.expr[i], ctx));
            for (Item it : map.keys()) {
                byte[] key;
                if (it instanceof Str) {
                    key = it.string(null);
                } else {
                    QNm qnm = (QNm)this.checkType(it, AtomType.QNM);
                    TokenBuilder tb = new TokenBuilder();
                    if (qnm.uri() != null) {
                        tb.add(123).add(qnm.uri()).add(125);
                    }
                    key = tb.add(qnm.local()).finish();
                }
                hm.put(Token.string(key), map.get(it, this.info));
            }
        }
        return hm;
    }

    final void cache(Iter ir, ValueBuilder vb, QueryContext ctx) throws QueryException {
        Item it;
        while ((it = ir.next()) != null) {
            ctx.checkStop();
            if (it instanceof FItem) {
                throw Err.FIVALUE.get(this.info, it.type);
            }
            Data d = it.data();
            if (d != null && !d.inMemory()) {
                it = ((ANode)it).dbCopy(ctx.context.options);
            }
            vb.add(it.materialize(this.info));
        }
    }

    static boolean oneOf(Function sig, Function ... sigs) {
        for (Function s : sigs) {
            if (sig != s) continue;
            return true;
        }
        return false;
    }
}

