/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.EnumMap;
import java.util.LinkedList;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.StaticDecl;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.XQFunction;
import org.basex.query.func.FNInfo;
import org.basex.query.func.FuncCall;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.StaticFuncs;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.Let;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class StaticFunc
extends StaticDecl
implements XQFunction {
    public final Var[] args;
    public final boolean updating;
    private final EnumMap<Expr.Flag, Boolean> map = new EnumMap(Expr.Flag.class);
    private boolean compiling;

    public StaticFunc(Ann a, QNm n, Var[] v, SeqType r, Expr e, StaticContext stc, VarScope scp, String xqdoc, InputInfo ii) {
        super(stc, a, n, r, scp, xqdoc, ii);
        this.args = v;
        this.expr = e;
        this.updating = this.ann.contains(Ann.Q_UPDATING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(QueryContext ctx) {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.compiling = true;
        Value cv = ctx.value;
        ctx.value = null;
        try {
            this.expr = this.expr.compile(ctx, this.scope);
            if (this.declType != null) {
                if ((this.declType.type == AtomType.BLN || this.declType.type == AtomType.FLT || this.declType.type == AtomType.DBL || this.declType.type == AtomType.QNM || this.declType.type == AtomType.URI) && this.declType.eq(this.expr.type())) {
                    ctx.compInfo("removing redundant % cast.", this.declType);
                } else {
                    this.expr = new TypeCheck(this.sc, this.info, this.expr, this.declType, true).optimize(ctx, this.scope);
                }
            }
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.expr.type());
        }
        finally {
            this.scope.cleanUp(this);
            ctx.value = cv;
        }
        this.expr.markTailCalls(ctx);
        this.compiling = false;
    }

    private boolean inline(QueryContext ctx) {
        return this.expr.isValue() || this.expr.exprSize() < ctx.context.options.get(MainOptions.INLINELIMIT) && !this.compiling && !this.has(Expr.Flag.CTX) && !this.selfRecursive();
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(QueryText.NAM, this.name.string());
        this.addPlan(plan, el, this.expr);
        for (int i = 0; i < this.args.length; ++i) {
            el.add(this.planAttr("arg" + i, this.args[i].name.string()));
        }
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("declare").add(32).addExt(this.ann, new Object[0]);
        if (this.updating) {
            tb.add("updating").add(32);
        }
        tb.add("function").add(32).add(this.name.string());
        tb.add("(").addSep(this.args, ", ").add(")");
        if (this.declType != null) {
            tb.add(" as " + this.declType);
        }
        if (this.expr != null) {
            tb.add(" { ").addExt(this.expr, new Object[0]).add(" }; ");
        } else {
            tb.add(" external; ");
        }
        return tb.toString();
    }

    private boolean selfRecursive() {
        return !this.expr.accept(new ASTVisitor(){

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return call.func != StaticFunc.this;
            }

            @Override
            public boolean inlineFunc(Scope sub) {
                return sub.visit(this);
            }
        });
    }

    @Override
    public int arity() {
        return this.args.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm argName(int pos) {
        return this.args[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.ann, this.args, this.declType);
    }

    @Override
    public int stackFrameSize() {
        return this.scope.stackSize();
    }

    @Override
    public Ann annotations() {
        return this.ann;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item invItem(QueryContext ctx, InputInfo ii, Value ... arg) throws QueryException {
        Value cv = ctx.value;
        ctx.value = null;
        try {
            for (int i = 0; i < this.args.length; ++i) {
                ctx.set(this.args[i], arg[i], ii);
            }
            Item item = this.expr.item(ctx, ii);
            return item;
        }
        finally {
            ctx.value = cv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... arg) throws QueryException {
        Value cv = ctx.value;
        ctx.value = null;
        try {
            for (int i = 0; i < this.args.length; ++i) {
                ctx.set(this.args[i], arg[i], ii);
            }
            Value value = ctx.value(this.expr);
            return value;
        }
        finally {
            ctx.value = cv;
        }
    }

    @Override
    public Value invokeValue(QueryContext ctx, InputInfo ii, Value ... arg) throws QueryException {
        return FuncCall.value(this, arg, ctx, ii);
    }

    @Override
    public Item invokeItem(QueryContext ctx, InputInfo ii, Value ... arg) throws QueryException {
        return FuncCall.item(this, arg, ctx, ii);
    }

    public void checkUp() throws QueryException {
        InputInfo ii;
        boolean u = this.expr.has(Expr.Flag.UPD);
        if (u) {
            this.expr.checkUp();
        }
        InputInfo inputInfo = ii = this.expr instanceof ParseExpr ? ((ParseExpr)this.expr).info : this.info;
        if (this.updating) {
            if (this.declType != null) {
                throw Err.UPFUNCTYPE.get(this.info, new Object[0]);
            }
            if (!u && !this.expr.isVacuous()) {
                throw Err.UPEXPECTF.get(ii, new Object[0]);
            }
        } else if (u) {
            throw Err.UPNOT.get(ii, this.description());
        }
    }

    public boolean isVacuous() {
        return !this.has(Expr.Flag.UPD) && this.declType != null && this.declType.eq(SeqType.EMP);
    }

    public boolean has(Expr.Flag flag) {
        Boolean b = this.map.get((Object)flag);
        if (b == null) {
            this.map.put(flag, false);
            b = this.expr == null || this.expr.has(flag);
            this.map.put(flag, b);
        }
        return b;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var v : this.args) {
            if (visitor.declared(v)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public byte[] id() {
        return StaticFuncs.sig(this.name, this.args.length);
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, QueryContext ctx, VarScope scp, InputInfo ii) throws QueryException {
        if (!this.inline(ctx)) {
            return null;
        }
        ctx.compInfo("inlining %", new Object[]{this.id()});
        LinkedList<GFLWOR.Clause> cls = exprs.length == 0 ? null : new LinkedList<GFLWOR.Clause>();
        IntObjMap<Var> vs = new IntObjMap<Var>();
        for (int i = 0; i < this.args.length; ++i) {
            Var old = this.args[i];
            Var v = scp.newCopyOf(ctx, old);
            vs.put(old.id, v);
            cls.add(new Let(v, exprs[i], false, this.info).optimize(ctx, scp));
        }
        Expr cpy = this.expr.copy(ctx, scp, vs);
        return cls == null ? cpy : new GFLWOR(this.info, cls, cpy).optimize(ctx, scp);
    }
}

