/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class StaticFuncCall
extends FuncCall {
    private final StaticContext sc;
    final QNm name;
    StaticFunc func;

    public StaticFuncCall(QNm nm, Expr[] arg, StaticContext sctx, InputInfo ii) {
        this(nm, arg, sctx, null, ii);
    }

    private StaticFuncCall(QNm nm, Expr[] arg, StaticContext sctx, StaticFunc fun, InputInfo ii) {
        super(ii, arg);
        this.sc = sctx;
        this.name = nm;
        this.func = fun;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        if (this.func.ann.contains(Ann.Q_PRIVATE) && !Token.eq(this.func.sc.baseURI().string(), this.sc.baseURI().string())) {
            throw Err.FUNCPRIV.get(this.info, new Object[]{this.name.string()});
        }
        this.func.compile(ctx);
        Expr inl = this.func.inlineExpr(this.expr, ctx, scp, this.info);
        if (inl != null) {
            return inl;
        }
        this.type = this.func.type();
        return this;
    }

    @Override
    public StaticFuncCall optimize(QueryContext ctx, VarScope scp) {
        return this;
    }

    @Override
    public StaticFuncCall copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr[] arg = new Expr[this.expr.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = this.expr[i].copy(ctx, scp, vs);
        }
        StaticFuncCall call = new StaticFuncCall(this.name, arg, this.sc, this.func, this.info);
        call.type = this.type;
        call.size = this.size;
        return call;
    }

    public StaticFuncCall init(StaticFunc f) throws QueryException {
        this.func = f;
        if (f.ann.contains(Ann.Q_PRIVATE) && !Token.eq(this.sc.baseURI().string(), f.sc.baseURI().string())) {
            throw Err.FUNCPRIV.get(this.info, new Object[]{f.name.string()});
        }
        return this;
    }

    public StaticFunc func() {
        return this.func;
    }

    @Override
    public boolean isVacuous() {
        return this.func != null && this.func.isVacuous();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        if (super.has(flag)) {
            return true;
        }
        if (flag == Expr.Flag.FCS || flag == Expr.Flag.CTX) {
            return false;
        }
        return this.func == null || (flag == Expr.Flag.UPD ? this.func.updating : this.func.has(flag));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.name, QueryText.TCL, this.tailCall), this.expr);
    }

    @Override
    public String description() {
        return "Function";
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.string()).add(this.toString(", ")).toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.staticFuncCall(this) && super.accept(visitor);
    }

    @Override
    public StaticFunc evalFunc(QueryContext ctx) {
        return this.func;
    }

    @Override
    Value[] evalArgs(QueryContext ctx) throws QueryException {
        int al = this.expr.length;
        Value[] args = new Value[al];
        for (int a = 0; a < al; ++a) {
            args[a] = ctx.value(this.expr[a]);
        }
        return args;
    }
}

