/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.ArrayList;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.StandardFunc;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class GroupBy
extends GFLWOR.Clause {
    private final Spec[] specs;
    private Expr[] preExpr;
    private Var[] post;
    private final int nonOcc;

    public GroupBy(Spec[] gs, VarRef[] pr, Var[] pst, InputInfo ii) {
        super(ii, GroupBy.vars(gs, pst));
        this.specs = gs;
        this.preExpr = new Expr[pr.length];
        System.arraycopy(pr, 0, this.preExpr, 0, pr.length);
        this.post = pst;
        int n = 0;
        for (Spec spec : this.specs) {
            if (spec.occluded) continue;
            ++n;
        }
        this.nonOcc = n;
    }

    private GroupBy(Spec[] gs, Expr[] pe, Var[] pst, int no, InputInfo ii) {
        super(ii, GroupBy.vars(gs, pst));
        this.specs = gs;
        this.preExpr = pe;
        this.post = pst;
        this.nonOcc = no;
    }

    private static Var[] vars(Spec[] gs, Var[] vs) {
        Var[] res = new Var[gs.length + vs.length];
        for (int i = 0; i < gs.length; ++i) {
            res[i] = gs[i].var;
        }
        System.arraycopy(vs, 0, res, gs.length, vs.length);
        return res;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Group[] groups;
            private int pos;

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                if (this.groups == null) {
                    this.groups = this.init(ctx);
                }
                if (this.pos == this.groups.length) {
                    return false;
                }
                Group curr = this.groups[this.pos];
                this.groups[this.pos++] = null;
                int p = 0;
                for (Spec spec : GroupBy.this.specs) {
                    if (spec.occluded) continue;
                    Item key = curr.key[p++];
                    ctx.set(spec.var, key == null ? Empty.SEQ : key, GroupBy.this.info);
                }
                for (int i = 0; i < GroupBy.this.post.length; ++i) {
                    ctx.set(GroupBy.this.post[i], curr.ngv[i].value(), GroupBy.this.info);
                }
                return true;
            }

            private Group[] init(QueryContext ctx) throws QueryException {
                ArrayList<Group> grps = new ArrayList<Group>();
                IntObjMap<Group> map = new IntObjMap<Group>();
                Collation[] colls = new Collation[GroupBy.this.nonOcc];
                int p = 0;
                for (int i = 0; i < GroupBy.this.specs.length; ++i) {
                    if (((GroupBy)GroupBy.this).specs[i].occluded) continue;
                    colls[p++] = ((GroupBy)GroupBy.this).specs[i].coll;
                }
                while (sub.next(ctx)) {
                    Group fst;
                    Item[] key = new Item[GroupBy.this.nonOcc];
                    p = 0;
                    int hash = 1;
                    for (Spec spec : GroupBy.this.specs) {
                        Item atom;
                        Item ki = spec.item(ctx, GroupBy.this.info);
                        Item item = atom = ki == null ? null : StandardFunc.atom(ki, GroupBy.this.info);
                        if (!spec.occluded) {
                            key[p++] = atom;
                            hash = 31 * hash + (atom == null || spec.coll != null ? 0 : atom.hash(GroupBy.this.info));
                        }
                        ctx.set(spec.var, atom == null ? Empty.SEQ : atom, GroupBy.this.info);
                    }
                    Group grp = null;
                    Group g = fst = (Group)map.get(hash);
                    while (g != null) {
                        if (GroupBy.this.eq(key, g.key, colls)) {
                            grp = g;
                            break;
                        }
                        g = g.next;
                    }
                    if (grp == null) {
                        ValueBuilder[] ngs = new ValueBuilder[GroupBy.this.preExpr.length];
                        for (int i = 0; i < ngs.length; ++i) {
                            ngs[i] = new ValueBuilder();
                        }
                        grp = new Group(key, ngs);
                        grps.add(grp);
                        if (fst == null) {
                            map.put(hash, grp);
                        } else {
                            Group nxt = fst.next;
                            fst.next = grp;
                            grp.next = nxt;
                        }
                    }
                    for (int j = 0; j < GroupBy.this.preExpr.length; ++j) {
                        grp.ngv[j].add(GroupBy.this.preExpr[j].value(ctx));
                    }
                }
                return grps.toArray(new Group[grps.size()]);
            }
        };
    }

    private boolean eq(Item[] as, Item[] bs, Collation[] coll) throws QueryException {
        for (int i = 0; i < as.length; ++i) {
            Item b;
            Item a = as[i];
            if (!(a == null ^ (b = bs[i]) == null) && (a == null || a.equiv(b, coll[i], this.info))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        for (Spec spec : this.specs) {
            spec.plan(e);
        }
        plan.add(e);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.post.length; ++i) {
            sb.append("let").append(" (: post-group :) ").append(this.post[i]);
            sb.append(' ').append(":=").append(' ').append(this.preExpr[i]).append(' ');
        }
        sb.append("group").append(' ').append("by");
        for (i = 0; i < this.specs.length; ++i) {
            sb.append(i == 0 ? " " : ", ").append(this.specs[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Spec sp : this.specs) {
            if (!sp.has(flag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupBy compile(QueryContext cx, VarScope sc) throws QueryException {
        for (Expr expr : this.preExpr) {
            expr.compile(cx, sc);
        }
        for (Expr expr : this.specs) {
            ((Single)expr).compile(cx, sc);
        }
        return this.optimize(cx, sc);
    }

    @Override
    public GroupBy optimize(QueryContext ctx, VarScope scp) throws QueryException {
        for (int i = 0; i < this.preExpr.length; ++i) {
            SeqType it = this.preExpr[i].type();
            this.post[i].refineType(it.withOcc(it.mayBeZero() ? SeqType.Occ.ZERO_MORE : SeqType.Occ.ONE_MORE), ctx, this.info);
        }
        return this;
    }

    @Override
    public boolean removable(Var v) {
        for (Spec b : this.specs) {
            if (b.removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.specs).plus(VarUsage.sum(v, this.preExpr));
    }

    @Override
    public GFLWOR.Clause inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean b = GroupBy.inlineAll(ctx, scp, this.specs, v, e);
        boolean p = GroupBy.inlineAll(ctx, scp, this.preExpr, v, e);
        return b || p ? this.optimize(ctx, scp) : null;
    }

    @Override
    public GroupBy copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr[] pEx = Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.preExpr);
        Var[] ps = new Var[this.post.length];
        for (int i = 0; i < ps.length; ++i) {
            Var old = this.post[i];
            ps[i] = scp.newCopyOf(ctx, old);
            vs.put(old.id, ps[i]);
        }
        return new GroupBy((Spec[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.specs), pEx, ps, this.nonOcc, this.info);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (!GroupBy.visitAll(visitor, this.specs)) {
            return false;
        }
        for (Expr expr : this.preExpr) {
            if (expr.accept(visitor)) continue;
            return false;
        }
        for (ExprInfo exprInfo : this.post) {
            if (visitor.declared((Var)exprInfo)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean clean(QueryContext ctx, IntObjMap<Var> decl, BitArray used) {
        int len = this.preExpr.length;
        for (int i = 0; i < this.post.length; ++i) {
            if (used.get(this.post[i].id)) continue;
            this.preExpr = Array.delete(this.preExpr, i);
            this.post = Array.delete(this.post, i--);
        }
        return this.preExpr.length < len;
    }

    @Override
    boolean skippable(GFLWOR.Clause cl) {
        return false;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.preExpr);
        this.checkNoneUp(this.specs);
    }

    @Override
    long calcSize(long cnt) {
        return -1L;
    }

    @Override
    public int exprSize() {
        int sz = 0;
        for (Expr expr : this.preExpr) {
            sz += expr.exprSize();
        }
        for (Expr expr : this.specs) {
            sz += expr.exprSize();
        }
        return sz;
    }

    private static final class Group {
        final Item[] key;
        final ValueBuilder[] ngv;
        Group next;

        Group(Item[] k, ValueBuilder[] ng) {
            this.key = k;
            this.ngv = ng;
        }
    }

    public static final class Spec
    extends Single {
        public final Var var;
        public boolean occluded;
        public final Collation coll;

        public Spec(InputInfo ii, Var v, Expr e, Collation cl) {
            super(ii, e);
            this.var = v;
            this.coll = cl;
        }

        @Override
        public void plan(FElem plan) {
            FElem e = this.planElem(new Object[0]);
            this.var.plan(e);
            this.expr.plan(e);
            plan.add(e);
        }

        @Override
        public String toString() {
            TokenBuilder tb = new TokenBuilder().add(this.var.toString()).add(32).add(":=");
            tb.add(32).add(this.expr.toString());
            if (this.coll != null) {
                tb.add(32).add("collation").add(" \"").add(this.coll.uri()).add(34);
            }
            return tb.toString();
        }

        @Override
        public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
            return this.expr.item(ctx, ii);
        }

        @Override
        public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
            Var v = scp.newCopyOf(ctx, this.var);
            vs.put(this.var.id, v);
            Spec spec = new Spec(this.info, v, this.expr.copy(ctx, scp, vs), this.coll);
            spec.occluded = this.occluded;
            return spec;
        }

        @Override
        public boolean accept(ASTVisitor visitor) {
            return this.expr.accept(visitor) && visitor.declared(this.var);
        }

        @Override
        public int exprSize() {
            return this.expr.exprSize();
        }
    }
}

