/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Pos;
import org.basex.query.path.Axis;
import org.basex.query.path.CachedPath;
import org.basex.query.path.InvDocTest;
import org.basex.query.path.IterPath;
import org.basex.query.path.Path;
import org.basex.query.path.Step;
import org.basex.query.path.Test;
import org.basex.query.util.IndexContext;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public abstract class AxisPath
extends Path {
    AxisPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    final AxisPath finish(QueryContext ctx) {
        this.size = this.size(ctx);
        this.type = SeqType.get(this.steps[this.steps.length - 1].type().type, this.size);
        return this.useIterator() ? new IterPath(this.info, this.root, this.steps, this.type, this.size) : this;
    }

    private boolean useIterator() {
        if (this.root == null || !this.root.iterable()) {
            return false;
        }
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            switch (this.step((int)s).axis) {
                case ANC: 
                case ANCORSELF: 
                case PREC: 
                case PRECSIBL: {
                    return false;
                }
                case DESC: 
                case DESCORSELF: 
                case FOLL: 
                case FOLLSIBL: {
                    return s + 1 == sl || s + 2 == sl && this.step((int)(s + 1)).axis == Axis.ATTR;
                }
            }
        }
        return true;
    }

    @Override
    protected final Expr compilePath(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.root instanceof AxisPath) {
            Expr[] st = ((Path)this.root).steps;
            this.root = ((Path)this.root).root;
            for (Expr s : this.steps) {
                st = Array.add(st, s);
            }
            this.steps = st;
            ctx.compInfo("merging axis paths", new Object[0]);
            ctx.value = this.initial(ctx);
        }
        this.voidStep(this.steps, ctx);
        for (int s = 0; s < this.steps.length; ++s) {
            Expr e = this.steps[s].compile(ctx, scp);
            if (!(e instanceof Step)) {
                return e;
            }
            this.steps[s] = e;
        }
        this.optSteps(ctx);
        return this.optimize(ctx, scp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        Expr opt = super.optimize(ctx, scp);
        if (opt != this) {
            return opt;
        }
        Value v = ctx.value;
        try {
            ctx.value = this.initial(ctx);
            Data data = ctx.data();
            if (data != null && ctx.value.type == NodeType.DOC) {
                Expr e = this.index(ctx, data);
                if (e == this) {
                    e = this.children(ctx, data);
                }
                if (e != this) {
                    Expr expr = e.compile(ctx, scp);
                    return expr;
                }
            }
            AxisPath axisPath = this.finish(ctx);
            return axisPath;
        }
        finally {
            ctx.value = v;
        }
    }

    private Expr index(QueryContext ctx, Data data) throws QueryException {
        if (this.root == null) {
            return this;
        }
        IndexCosts ics = null;
        int pmin = 0;
        int smin = 0;
        for (int s = 0; s < this.steps.length; ++s) {
            Step step = this.step(s);
            if (!step.axis.down || step.has(Expr.Flag.FCS)) break;
            boolean i = this.pathNodes(data, s) != null;
            IndexContext ictx = new IndexContext(data, i);
            for (int p = 0; p < step.preds.length; ++p) {
                IndexCosts ic = new IndexCosts(ictx, ctx, step);
                if (!step.preds[p].indexAccessible(ic)) continue;
                if (ic.costs() == 0) {
                    if (ic.not) {
                        step.preds[p] = Bln.TRUE;
                        continue;
                    }
                    ctx.compInfo("removing path with no index results", this);
                    return Empty.SEQ;
                }
                if (ics != null && ics.costs() <= ic.costs()) continue;
                ics = ic;
                pmin = p;
                smin = s;
            }
        }
        if (ics == null || ics.costs() > data.meta.size) {
            return this;
        }
        Step stp = this.step(smin);
        Expr ie = stp.preds[pmin].indexEquivalent(ics);
        if (!ics.seq) {
            AxisPath result;
            boolean simple;
            int j;
            Expr[] invSteps = new Step[]{};
            Expr[] newPreds = new Expr[stp.preds.length - 1];
            int c = 0;
            for (int p = 0; p != stp.preds.length; ++p) {
                if (p == pmin) continue;
                newPreds[c++] = stp.preds[p];
            }
            Test test = InvDocTest.get(ctx, data);
            boolean inv = true;
            if (test == Test.DOC && data.meta.uptodate) {
                int name;
                ArrayList<PathNode> pn;
                Step s;
                for (j = 0; j <= smin && (s = this.axisStep(j)) != null && s.test.kind == Test.Kind.NAME && s.axis == Axis.CHILD && (j == smin || s.preds.length <= 0) && (pn = data.paths.desc(name = data.tagindex.id(s.test.name.local()), 1)).size() == 1 && pn.get(0).level() == j + 1; ++j) {
                }
                boolean bl = inv = j <= smin;
            }
            if (inv) {
                Axis ax;
                for (j = smin; j >= 0 && (ax = this.step((int)j).axis.invert()) != null; --j) {
                    if (j == 0) {
                        if (test == Test.DOC && (ax == Axis.ANC || ax == Axis.ANCORSELF)) continue;
                        invSteps = Array.add(invSteps, Step.get(this.info, ax, test, new Expr[0]));
                        continue;
                    }
                    Step prev = this.step(j - 1);
                    invSteps = Array.add(invSteps, Step.get(this.info, ax, prev.test, prev.preds));
                }
            }
            boolean bl = simple = invSteps.length == 0 && newPreds.length == 0;
            if (ie instanceof AxisPath) {
                result = (AxisPath)ie;
            } else if (smin + 1 < this.steps.length || !simple) {
                result = simple ? new CachedPath(this.info, ie, new Expr[0]) : new CachedPath(this.info, ie, Step.get(this.info, Axis.SELF, Test.NOD, new Expr[0]));
            } else {
                return ie;
            }
            int ls = result.steps.length - 1;
            if (ls >= 0) {
                result.steps[ls] = result.step(ls).addPreds(newPreds);
                if (invSteps.length != 0) {
                    result.steps[ls] = result.step(ls).addPreds(Path.get(this.info, null, invSteps));
                }
            }
            for (int s = smin + 1; s < this.steps.length; ++s) {
                result.steps = Array.add(result.steps, this.steps[s]);
            }
            return result;
        }
        stp.preds[pmin] = ie;
        return this;
    }

    public final AxisPath invertPath(Expr r, Step curr) {
        int s = this.steps.length;
        Expr[] e = new Expr[s--];
        Expr rt = this.step((int)s).preds.length == 0 ? r : Filter.get(this.info, r, this.step((int)s).preds);
        int c = 0;
        while (--s >= 0) {
            e[c++] = Step.get(this.info, this.step((int)(s + 1)).axis.invert(), this.step((int)s).test, this.step((int)s).preds);
        }
        e[c] = Step.get(this.info, this.step((int)(s + 1)).axis.invert(), curr.test, new Expr[0]);
        return new CachedPath(this.info, rt, e);
    }

    @Override
    public final Expr addText(QueryContext ctx) {
        Step s = this.step(this.steps.length - 1);
        if (s.preds.length != 0 || !s.axis.down || s.test.type == NodeType.ATT || s.test.kind != Test.Kind.NAME && s.test.kind != Test.Kind.URI_NAME) {
            return this;
        }
        Data data = ctx.data();
        if (data == null || !data.meta.uptodate) {
            return this;
        }
        Stats stats = data.tagindex.stat(data.tagindex.id(s.test.name.local()));
        if (stats != null && stats.isLeaf()) {
            this.steps = Array.add(this.steps, Step.get(this.info, Axis.CHILD, Test.TXT, new Expr[0]));
            ctx.compInfo("adding text() step", this);
        }
        return this;
    }

    public final Step step(int i) {
        return (Step)this.steps[i];
    }

    public ArrayList<PathNode> nodes(QueryContext ctx) {
        Data data;
        Value init = this.initial(ctx);
        Data data2 = data = init != null && init.type == NodeType.DOC ? init.data() : null;
        if (data == null || !data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        for (int s = 0; s < this.steps.length; ++s) {
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            if ((nodes = curr.nodes(nodes, data)) != null) continue;
            return null;
        }
        return nodes;
    }

    @Override
    public final boolean removable(Var v) {
        for (Expr s : this.steps) {
            if (s.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    public boolean cheap() {
        if (!(this.root instanceof ANode) || ((Value)this.root).type != NodeType.DOC) {
            return false;
        }
        Axis[] expensive = new Axis[]{Axis.DESC, Axis.DESCORSELF, Axis.PREC, Axis.PRECSIBL, Axis.FOLL, Axis.FOLLSIBL};
        for (int i = 0; i < this.steps.length; ++i) {
            Expr[] ps;
            Step s = this.step(i);
            if (i < 2) {
                for (Axis a : expensive) {
                    if (s.axis != a) continue;
                    return false;
                }
            }
            if ((ps = s.preds).length == 0 || ps.length == 1 && ps[0] instanceof Pos) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof AxisPath)) {
            return false;
        }
        AxisPath ap = (AxisPath)cmp;
        if ((this.root == null || ap.root == null) && this.root != ap.root || this.steps.length != ap.steps.length || this.root != null && !this.root.sameAs(ap.root)) {
            return false;
        }
        for (int s = 0; s < this.steps.length; ++s) {
            if (this.steps[s].sameAs(ap.steps[s])) continue;
            return false;
        }
        return true;
    }
}

