/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Export;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.AtomicUpdateCache;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.NodeUpdateComparator;
import org.basex.query.up.NodeUpdates;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.NodeCopy;
import org.basex.query.up.primitives.NodeUpdate;
import org.basex.query.up.primitives.Put;
import org.basex.query.util.Err;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.NodeType;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;

final class DataUpdates {
    private final Data data;
    private IntList nodes = new IntList(0);
    private IntObjMap<NodeUpdates> nodeUpdates = new IntObjMap();
    private final List<DBUpdate> dbUpdates = new LinkedList<DBUpdate>();
    private final IntObjMap<Put> puts = new IntObjMap();
    private int size;

    DataUpdates(Data d) {
        this.data = d;
    }

    void add(DataUpdate up, MemData tmp) throws QueryException {
        if (up instanceof NodeUpdate) {
            for (NodeUpdate nodeUp : ((NodeUpdate)up).substitute(tmp)) {
                int pre = nodeUp.pre;
                NodeUpdates pc = this.nodeUpdates.get(pre);
                if (pc == null) {
                    pc = new NodeUpdates();
                    this.nodeUpdates.put(pre, pc);
                }
                pc.add(nodeUp);
            }
        } else if (up instanceof Put) {
            Put p = (Put)up;
            int id = p.nodeid;
            Put old = this.puts.get(id);
            if (old == null) {
                this.puts.put(id, p);
            } else {
                old.merge(p);
            }
        } else {
            DBUpdate dbUp = (DBUpdate)up;
            for (DBUpdate o : this.dbUpdates) {
                if (o.type != dbUp.type) continue;
                o.merge(dbUp);
                return;
            }
            this.dbUpdates.add(dbUp);
        }
    }

    void prepare(MemData tmp) throws QueryException {
        int i;
        for (DBUpdate d : this.dbUpdates) {
            d.prepare(tmp);
        }
        int s = this.nodeUpdates.size();
        this.nodes = new IntList(s);
        for (i = 1; i <= s; ++i) {
            this.nodes.add(this.nodeUpdates.key(i));
        }
        this.nodes.sort();
        for (i = 0; i < s; ++i) {
            NodeUpdates ups = this.nodeUpdates.get(this.nodes.get(i));
            for (NodeUpdate p : ups.updates) {
                if (!(p instanceof NodeCopy)) continue;
                ((NodeCopy)p).prepare(tmp);
            }
        }
        int p = this.nodes.size() - 1;
        int par = -1;
        while (p >= 0 && (par != this.nodes.get(p) || --p >= 0)) {
            int pre = this.nodes.get(p);
            if (pre == -1) {
                return;
            }
            int k = this.data.kind(pre);
            if (k == 3) {
                par = this.data.parent(pre, 3);
                IntList il = new IntList();
                while (p >= 0 && (pre = this.nodes.get(p)) > par) {
                    il.add(pre);
                    --p;
                }
                if (par != -1) {
                    il.add(par);
                }
                this.checkNames(il.toArray());
                continue;
            }
            if (k == 1) {
                this.checkNames(pre);
            }
            --p;
        }
    }

    void finishUpdate() {
        this.data.finishUpdate();
    }

    Data data() {
        return this.data;
    }

    void apply() throws QueryException {
        this.createAtomicUpdates(this.preparePrimitives()).execute(true);
        Collections.sort(this.dbUpdates);
        for (DBUpdate bo : this.dbUpdates) {
            bo.apply();
        }
        for (Put put : this.puts.values()) {
            put.apply();
        }
        if (this.data.inMemory() && !this.data.meta.original.isEmpty() && this.data.meta.options.get(MainOptions.WRITEBACK).booleanValue()) {
            try {
                Export.export(this.data, this.data.meta.original, null);
            }
            catch (IOException ex) {
                throw Err.UPPUTERR.get(null, this.data.meta.original);
            }
        }
    }

    private List<NodeUpdate> preparePrimitives() {
        int i;
        ArrayList<NodeUpdate> upd = new ArrayList<NodeUpdate>();
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            int pre = this.nodes.get(i);
            NodeUpdates n = this.nodeUpdates.get(pre);
            for (NodeUpdate p : n.finish()) {
                upd.add(p);
                this.size += p.size();
            }
        }
        for (i = this.dbUpdates.size() - 1; i >= 0; --i) {
            this.size += this.dbUpdates.get(i).size();
        }
        this.nodeUpdates = null;
        this.nodes = null;
        Collections.sort(upd, new NodeUpdateComparator());
        return upd;
    }

    private AtomicUpdateCache createAtomicUpdates(List<NodeUpdate> l) {
        AtomicUpdateCache atomics = new AtomicUpdateCache(this.data);
        for (int i = 0; i < l.size(); ++i) {
            NodeUpdate u = l.get(i);
            u.addAtomics(atomics);
            l.set(i, null);
        }
        return atomics;
    }

    int size() {
        return this.size;
    }

    private void checkNames(int ... pres) throws QueryException {
        NamePool pool = new NamePool();
        for (int pre : pres) {
            NodeUpdates ups = this.nodeUpdates.get(pre);
            if (ups == null) continue;
            for (NodeUpdate up : ups.updates) {
                up.update(pool);
            }
        }
        if (!pool.nsOK()) {
            throw Err.UPNSCONFL2.get(null, new Object[0]);
        }
        IntSet il = new IntSet();
        for (int pre : pres) {
            if (this.data.kind(pre) == 3) {
                byte[] nm = this.data.name(pre, 3);
                QNm name = new QNm(nm);
                byte[] uri = this.data.nspaces.uri(this.data.nspaces.uri(nm, pre, this.data));
                if (uri != null) {
                    name.uri(uri);
                }
                pool.add(name, NodeType.ATT);
                il.add(pre);
                continue;
            }
            int ps = pre + this.data.attSize(pre, 1);
            for (int p = pre + 1; p < ps; ++p) {
                byte[] nm = this.data.name(p, 3);
                if (il.contains(p)) continue;
                QNm name = new QNm(nm);
                byte[] uri = this.data.nspaces.uri(this.data.nspaces.uri(nm, p, this.data));
                if (uri != null) {
                    name.uri(uri);
                }
                pool.add(name, NodeType.ATT);
            }
        }
        QNm dup = pool.duplicate();
        if (dup != null) {
            throw Err.UPATTDUPL.get(null, dup);
        }
    }
}

