/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class NamePool {
    private NameCache[] cache = new NameCache[1];
    private int size;

    public void add(QNm name, NodeType type) {
        if (type != NodeType.ATT && type != NodeType.ELM) {
            return;
        }
        int i = this.index(name, type == NodeType.ATT);
        ++this.cache[i].add;
    }

    public void remove(ANode node) {
        if (node.type != NodeType.ATT && node.type != NodeType.ELM) {
            return;
        }
        int i = this.index(node.qname(), node.type == NodeType.ATT);
        this.cache[i].del = true;
    }

    QNm duplicate() {
        for (int i = 0; i < this.size; ++i) {
            if (!this.cache[i].attr || this.cache[i].add <= (this.cache[i].del ? 2 : 1)) continue;
            return this.cache[i].name;
        }
        return null;
    }

    boolean nsOK() {
        Atts at = new Atts();
        for (int i = 0; i < this.size; ++i) {
            if (this.cache[i].add <= (this.cache[i].del ? 1 : 0)) continue;
            QNm nm = this.cache[i].name;
            byte[] pref = nm.prefix();
            byte[] uri = nm.uri();
            if (this.cache[i].attr && uri.length == 0) continue;
            byte[] u = at.value(pref);
            if (u == null) {
                at.add(pref, uri);
                continue;
            }
            if (Token.eq(uri, u)) continue;
            return false;
        }
        return true;
    }

    private int index(QNm name, boolean at) {
        for (int i = 0; i < this.size; ++i) {
            NameCache nc = this.cache[i];
            if (!nc.name.eq(name) || nc.attr != at) continue;
            return i;
        }
        if (this.size == this.cache.length) {
            this.cache = Array.copy(this.cache, new NameCache[Array.newSize(this.size)]);
        }
        NameCache nc = new NameCache();
        nc.name = name;
        nc.attr = at;
        this.cache[this.size] = nc;
        return this.size++;
    }

    static final class NameCache {
        QNm name;
        boolean attr;
        int add;
        boolean del;

        NameCache() {
        }
    }
}

