/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.ft.Language;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class DBOptimize
extends DBUpdate {
    private final DBOptions options;
    private final QueryContext qc;
    private boolean all;

    public DBOptimize(Data data, boolean all, Options opts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBOPTIMIZE, data, info);
        this.all = all;
        this.qc = qc;
        ArrayList supported = new ArrayList();
        for (Option<?> option : DBOptions.INDEXING) {
            if (!all && option == MainOptions.UPDINDEX) continue;
            supported.add(option);
        }
        this.options = new DBOptions(opts.free(), supported, info);
    }

    @Override
    public void merge(Update up) {
        this.all |= ((DBOptimize)up).all;
    }

    @Override
    public void prepare(MemData tmp) {
    }

    @Override
    public void apply() throws QueryException {
        MetaData meta = this.data.meta;
        MainOptions opts = meta.options;
        this.options.assign(MainOptions.TEXTINDEX, meta.createtext);
        this.options.assign(MainOptions.ATTRINDEX, meta.createattr);
        this.options.assign(MainOptions.FTINDEX, meta.createftxt);
        this.options.assign(MainOptions.UPDINDEX, meta.updindex);
        this.options.assign(opts);
        meta.createtext = opts.get(MainOptions.TEXTINDEX);
        meta.createattr = opts.get(MainOptions.ATTRINDEX);
        meta.createftxt = opts.get(MainOptions.FTINDEX);
        meta.updindex = opts.get(MainOptions.UPDINDEX);
        int mc = opts.get(MainOptions.MAXCATS);
        int ml = opts.get(MainOptions.MAXLEN);
        boolean rebuild = mc != meta.maxcats || ml != meta.maxlen;
        boolean st = opts.get(MainOptions.STEMMING);
        boolean cs = opts.get(MainOptions.CASESENS);
        boolean dc = opts.get(MainOptions.DIACRITICS);
        String sw = opts.get(MainOptions.STOPWORDS);
        Language ln = Language.get(opts);
        boolean rebuildFT = rebuild || !ln.equals(meta.language) || st != meta.stemming || cs != meta.casesens || dc != meta.diacritics || !sw.equals(meta.stopwords);
        meta.language = ln;
        meta.stemming = st;
        meta.casesens = cs;
        meta.diacritics = dc;
        meta.stopwords = sw;
        meta.maxcats = mc;
        meta.maxlen = ml;
        try {
            if (this.all) {
                OptimizeAll.optimizeAll(this.data, this.qc.context, null);
            } else {
                Optimize.optimize(this.data, rebuild, rebuildFT, null);
            }
        }
        catch (IOException ex) {
            throw Err.UPDBOPTERR.get(this.info, ex);
        }
        finally {
            this.options.reset(opts);
        }
        if (this.all) {
            this.qc.resource.remove(this.data.meta.name);
        }
    }

    @Override
    public int size() {
        return 1;
    }
}

