/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.QueryInput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class DBStore
extends DBUpdate {
    private final TokenObjMap<Object> map = new TokenObjMap();

    public DBStore(Data data, String path, Object it, InputInfo inf) {
        super(UpdateType.DBSTORE, data, inf);
        this.map.put(Token.token(path), it);
    }

    @Override
    public void merge(Update up) {
        DBStore put = (DBStore)up;
        for (byte[] path : put.map) {
            this.map.put(path, put.map.get(path));
        }
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.map) {
            try {
                IOFile file = this.data.meta.binary(Token.string(path));
                if (file == null) {
                    throw Err.UPDBPUTERR.get(this.info, new Object[]{path});
                }
                file.dir().md();
                Object item = this.map.get(path);
                file.write(item instanceof Item ? ((Item)item).input(this.info) : ((QueryInput)item).input.inputStream());
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw Err.UPDBPUTERR.get(this.info, new Object[]{path});
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void prepare(MemData tmp) {
    }
}

