/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.query.util.archive.ArchiveOut;
import org.basex.util.Util;

public final class ZIPOut
extends ArchiveOut {
    private final ZipOutputStream zos;

    public ZIPOut() {
        this.zos = new ZipOutputStream(this.ao);
    }

    @Override
    public void level(int l) {
        this.zos.setLevel(l);
    }

    @Override
    public void write(ArchiveIn in) throws IOException {
        int c;
        ZipEntry zi = in.entry();
        ZipEntry zo = new ZipEntry(zi.getName());
        zo.setTime(zi.getTime());
        zo.setComment(zi.getComment());
        this.zos.putNextEntry(zo);
        while ((c = in.read(this.data)) != -1) {
            this.zos.write(this.data, 0, c);
        }
        this.zos.closeEntry();
    }

    @Override
    public void write(ZipEntry entry, byte[] val) throws IOException {
        this.zos.putNextEntry(entry);
        this.zos.write(val);
        this.zos.closeEntry();
    }

    @Override
    public void close() {
        try {
            this.zos.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }
}

