/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.Locale;
import org.basex.core.MainOptions;
import org.basex.io.IOUrl;
import org.basex.io.MimeTypes;
import org.basex.io.in.TextInput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.util.http.HTTPRequest;
import org.basex.query.util.http.HTTPRequestParser;
import org.basex.query.util.http.HTTPResponse;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;

public final class HTTPClient {
    private final InputInfo info;
    private final MainOptions options;

    public HTTPClient(InputInfo ii, MainOptions opts) {
        this.info = ii;
        this.options = opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iter sendRequest(byte[] href, ANode request, ValueBuilder bodies) throws QueryException {
        try {
            byte[] dest;
            if (request == null) {
                if (href == null) throw Err.HC_PARAMS.get(this.info, new Object[0]);
                if (href.length == 0) {
                    throw Err.HC_PARAMS.get(this.info, new Object[0]);
                }
                HttpURLConnection conn = this.openConnection(Token.string(href));
                try {
                    ValueIter valueIter = new HTTPResponse(this.info, this.options).getResponse(conn, Bln.FALSE.string(), null);
                    return valueIter;
                }
                finally {
                    conn.disconnect();
                }
            }
            HTTPRequest r = new HTTPRequestParser(this.info).parse(request, bodies);
            byte[] byArray = dest = href == null ? r.attrs.get(HTTPText.HREF) : href;
            if (dest == null) {
                throw Err.HC_URL.get(this.info, new Object[0]);
            }
            HttpURLConnection conn = this.openConnection(Token.string(dest));
            try {
                this.setConnectionProps(conn, r);
                this.setRequestHeaders(conn, r);
                if (r.bodyContent.size() != 0L || !r.parts.isEmpty()) {
                    HTTPClient.setContentType(conn, r);
                    this.setRequestContent(conn.getOutputStream(), r);
                }
                byte[] mt = r.attrs.get(HTTPText.OVERRIDE_MEDIA_TYPE);
                ValueIter valueIter = new HTTPResponse(this.info, this.options).getResponse(conn, r.attrs.get(HTTPText.STATUS_ONLY), mt == null ? null : Token.string(mt));
                return valueIter;
            }
            finally {
                conn.disconnect();
            }
        }
        catch (IOException ex) {
            throw Err.HC_ERROR.get(this.info, ex);
        }
    }

    private HttpURLConnection openConnection(String url) throws QueryException, IOException {
        URLConnection conn = new IOUrl(url).connection();
        if (conn instanceof HttpURLConnection) {
            return (HttpURLConnection)conn;
        }
        throw Err.HC_ERROR.get(this.info, "Invalid URL: " + url);
    }

    private void setConnectionProps(HttpURLConnection conn, HTTPRequest r) throws ProtocolException, QueryException {
        byte[] redirect;
        conn.setDoOutput(true);
        String method = Token.string(r.attrs.get(HTTPText.METHOD)).toUpperCase(Locale.ENGLISH);
        try {
            Field f = conn.getClass().getSuperclass().getDeclaredField("method");
            f.setAccessible(true);
            f.set(conn, method);
        }
        catch (Throwable th) {
            conn.setRequestMethod(method);
        }
        byte[] timeout = r.attrs.get(HTTPText.TIMEOUT);
        if (timeout != null) {
            conn.setConnectTimeout(Integer.parseInt(Token.string(timeout)));
        }
        if ((redirect = r.attrs.get(HTTPText.FOLLOW_REDIRECT)) != null) {
            HttpURLConnection.setFollowRedirects(Bln.parse(redirect, this.info));
        }
    }

    private static void setContentType(HttpURLConnection conn, HTTPRequest r) {
        String mt;
        byte[] contTypeHdr = r.headers.get(Token.lc(Token.token("Content-Type")));
        if (contTypeHdr != null) {
            mt = Token.string(contTypeHdr);
        } else {
            mt = Token.string(r.payloadAttrs.get(HTTPText.MEDIA_TYPE));
            if (r.isMultipart) {
                byte[] b = r.payloadAttrs.get(HTTPText.BOUNDARY);
                byte[] boundary = b != null ? b : HTTPText.DEFAULT_BOUND;
                TokenBuilder tb = new TokenBuilder();
                mt = tb.add(mt).add("; ").add(HTTPText.BOUNDARY).add(61).add(boundary).toString();
            }
        }
        conn.setRequestProperty("Content-Type", mt);
    }

    private void setRequestHeaders(HttpURLConnection conn, HTTPRequest r) throws QueryException {
        for (byte[] headers : r.headers) {
            conn.addRequestProperty(Token.string(headers), Token.string(r.headers.get(headers)));
        }
        byte[] sendAuth = r.attrs.get(HTTPText.SEND_AUTHORIZATION);
        if (sendAuth != null && Bln.parse(sendAuth, this.info)) {
            conn.setRequestProperty("Authorization", HTTPClient.encodeCredentials(Token.string(r.attrs.get(HTTPText.USERNAME)), Token.string(r.attrs.get(HTTPText.PASSWORD))));
        }
    }

    public void setRequestContent(OutputStream out, HTTPRequest r) throws IOException {
        if (r.isMultipart) {
            this.writeMultipart(r, out);
        } else {
            HTTPClient.writePayload(r.bodyContent, r.payloadAttrs, out);
        }
        out.close();
    }

    private static String encodeCredentials(String u, String p) {
        return "Basic " + Base64.encode(u + ':' + p);
    }

    private static void writePayload(ValueBuilder payload, TokenMap payloadAtts, OutputStream out) throws IOException {
        String method;
        byte[] m = payloadAtts.get(HTTPText.METHOD);
        if (m == null) {
            String type;
            byte[] tp = payloadAtts.get(HTTPText.MEDIA_TYPE);
            String string = type = tp == null ? "" : Token.string(tp);
            method = Token.eq(type, "application/html+xml") ? SerialMethod.XHTML.toString() : (Token.eq(type, "text/html") ? SerialMethod.HTML.toString() : (type != null && MimeTypes.isXML(type) ? SerialMethod.XML.toString() : (type != null && MimeTypes.isText(type) ? SerialMethod.TEXT.toString() : SerialMethod.XML.toString())));
        } else {
            method = Token.string(m);
        }
        byte[] src = payloadAtts.get(HTTPText.SRC);
        if (src == null) {
            HTTPClient.write(payload, payloadAtts, method, out);
        } else {
            IOUrl io = new IOUrl(Token.string(src));
            if (Token.eq(method, "binary")) {
                out.write(io.read());
            } else {
                ValueBuilder vb = new ValueBuilder().add(Str.get(new TextInput(io).content()));
                HTTPClient.write(vb, payloadAtts, method, out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(ValueBuilder payload, TokenMap attrs, String method, OutputStream out) throws IOException {
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.METHOD, method);
        for (byte[] key : attrs) {
            if (Token.eq(key, HTTPText.SRC)) continue;
            sopts.assign(Token.string(key), Token.string(attrs.get(key)));
        }
        Serializer ser = Serializer.get(out, sopts);
        try {
            payload.serialize(ser);
        }
        finally {
            ser.close();
        }
    }

    private void writeMultipart(HTTPRequest r, OutputStream out) throws IOException {
        byte[] boundary = r.payloadAttrs.get(HTTPText.BOUNDARY);
        for (HTTPRequest.Part part : r.parts) {
            this.writePart(part, out, boundary);
        }
        out.write(new TokenBuilder("--").add(boundary).add("--").add(HTTPText.CRLF).finish());
    }

    private void writePart(HTTPRequest.Part part, OutputStream out, byte[] boundary) throws IOException {
        TokenBuilder boundTb = new TokenBuilder();
        boundTb.add("--").add(boundary).add(HTTPText.CRLF);
        out.write(boundTb.finish());
        for (byte[] header : part.headers) {
            TokenBuilder hdrTb = new TokenBuilder();
            hdrTb.add(header).add(": ").add(part.headers.get(header)).add(HTTPText.CRLF);
            out.write(hdrTb.finish());
        }
        out.write(HTTPText.CRLF);
        HTTPClient.writePayload(part.bodyContent, part.bodyAttrs, out);
        out.write(HTTPText.CRLF);
    }
}

