/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.HashMap;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Map
extends FItem {
    public static final Map EMPTY = new Map(TrieNode.EMPTY);
    static final int BITS = 5;
    private final TrieNode root;
    private Value keys;

    private Map(TrieNode m) {
        super(SeqType.ANY_MAP, new Ann());
        this.root = m;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public QNm funcName() {
        return null;
    }

    @Override
    public QNm argName(int pos) {
        return new QNm("key", "");
    }

    @Override
    public FuncType funcType() {
        return MapType.get(AtomType.AAT, SeqType.ITEM_ZM);
    }

    @Override
    public int stackFrameSize() {
        return 0;
    }

    @Override
    public Item invItem(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.get(args[0].item(ctx, ii), ii).item(ctx, ii);
    }

    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.get(args[0].item(ctx, ii), ii);
    }

    private Item key(Item it, InputInfo ii) throws QueryException {
        if (it == null) {
            throw Err.INVEMPTY.get(ii, this.description());
        }
        if (it instanceof FItem) {
            throw Err.FIATOM.get(ii, it.type);
        }
        if (it == Flt.NAN || it == Dbl.NAN) {
            return null;
        }
        return it.type.isUntyped() ? Str.get(it.string(ii)) : it;
    }

    public Map delete(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return this;
        }
        TrieNode del = this.root.delete(k.hash(ii), k, 0, ii);
        return del == this.root ? this : (del != null ? new Map(del) : EMPTY);
    }

    public Value get(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return Empty.SEQ;
        }
        Value val = this.root.get(k.hash(ii), k, 0, ii);
        return val == null ? Empty.SEQ : val;
    }

    public boolean contains(Item k, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        return key != null && this.root.contains(key.hash(ii), key, 0, ii);
    }

    public Map addAll(Map other, InputInfo ii) throws QueryException {
        if (other == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(other.root, 0, ii);
        return upd == other.root ? other : new Map(upd);
    }

    public boolean hasType(MapType t) {
        return this.root.hasType(t.keyType == AtomType.AAT ? null : t.keyType, t.ret.eq(SeqType.ITEM_ZM) ? null : t.ret);
    }

    @Override
    public Map coerceTo(FuncType ft, QueryContext ctx, InputInfo ii, boolean opt) throws QueryException {
        if (!(ft instanceof MapType) || !this.hasType((MapType)ft)) {
            throw Err.castError(ii, ft, this);
        }
        return this;
    }

    public Map insert(Item k, Value v, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        if (key == null) {
            return this;
        }
        TrieNode ins = this.root.insert(key.hash(ii), key, v, 0, ii);
        return ins == this.root ? this : new Map(ins);
    }

    public int mapSize() {
        return this.root.size;
    }

    public Value keys() {
        if (this.keys == null) {
            ValueBuilder res = new ValueBuilder(this.root.size);
            this.root.keys(res);
            this.keys = res.value();
        }
        return this.keys;
    }

    public Str collation() {
        return Str.get(QueryText.COLLATIONURI);
    }

    public boolean deep(InputInfo ii, Map o) throws QueryException {
        return this.root.deep(ii, o.root);
    }

    public byte[] serialize(InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        this.string(tb, 0, ii);
        return tb.finish();
    }

    @Override
    public HashMap<Object, Object> toJava() throws QueryException {
        Item k;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ValueIter vi = this.keys().iter();
        while ((k = vi.next()) != null) {
            map.put(k.toJava(), this.get(k, null).toJava());
        }
        return map;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.root.hash(ii);
    }

    @Override
    public String description() {
        return "{...}";
    }

    @Override
    public void plan(FElem plan) {
        int s = this.mapSize();
        FElem el = this.planElem(QueryText.SIZE, s);
        Value ks = this.keys();
        try {
            int max = Math.min(s, 5);
            for (long i = 0L; i < (long)max; ++i) {
                Item key = ks.itemAt(i);
                Value val = this.get(key, null);
                key.plan(el);
                val.plan(el);
            }
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex);
        }
        this.addPlan(plan, el, new ExprInfo[0]);
    }

    private void string(TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add("{");
        int c = 0;
        for (Item key : this.keys()) {
            if (c++ > 0) {
                tb.add(44);
            }
            tb.add(10);
            Map.indent(tb, level + 1);
            tb.add(key.toString());
            tb.add(": ");
            Value v = this.get(key, ii);
            if (v.size() != 1L) {
                tb.add(40);
            }
            int cc = 0;
            for (Item it : v) {
                if (cc++ > 0) {
                    tb.add(", ");
                }
                if (it instanceof Map) {
                    ((Map)it).string(tb, level + 1, ii);
                    continue;
                }
                tb.add(it.toString());
            }
            if (v.size() == 1L) continue;
            tb.add(41);
        }
        tb.add(10);
        Map.indent(tb, level);
        tb.add(125);
    }

    private static void indent(TokenBuilder tb, int level) {
        for (int l = 0; l < level; ++l) {
            tb.add("  ");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = this.root.toString(new StringBuilder("map").append(" { "));
        if (this.root.size > 0) {
            sb.deleteCharAt(sb.length() - 2);
        }
        return sb.append('}').toString();
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, QueryContext ctx, VarScope scp, InputInfo ii) {
        return null;
    }
}

