/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.math.BigDecimal;
import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class DecSeq
extends NativeSeq {
    private final BigDecimal[] values;

    private DecSeq(BigDecimal[] vals) {
        super(vals.length, (Type)AtomType.DEC);
        this.values = vals;
    }

    @Override
    public Dec itemAt(long pos) {
        return Dec.get(this.values[(int)pos]);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof DecSeq && Arrays.equals(this.values, ((DecSeq)cmp).values);
    }

    public BigDecimal[] toJava() {
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        BigDecimal[] tmp = new BigDecimal[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return DecSeq.get(tmp);
    }

    private static Value get(BigDecimal[] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Dec.get(items[0]) : new DecSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        BigDecimal[] tmp = new BigDecimal[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).dec(null);
                continue;
            }
            if (val instanceof DecSeq) {
                DecSeq sq = (DecSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).dec(null);
            }
        }
        return DecSeq.get(tmp);
    }
}

