/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class FltSeq
extends NativeSeq {
    private final float[] values;

    private FltSeq(float[] vals) {
        super(vals.length, (Type)AtomType.FLT);
        this.values = vals;
    }

    @Override
    public Flt itemAt(long pos) {
        return Flt.get(this.values[(int)pos]);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof FltSeq && Arrays.equals(this.values, ((FltSeq)cmp).values);
    }

    public float[] toJava() {
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        float[] tmp = new float[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return FltSeq.get(tmp);
    }

    public static Value get(float[] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Flt.get(items[0]) : new FltSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        float[] tmp = new float[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).flt(null);
                continue;
            }
            if (val instanceof FltSeq) {
                FltSeq sq = (FltSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).flt(null);
            }
        }
        return FltSeq.get(tmp);
    }
}

