/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class IntSeq
extends NativeSeq {
    private final long[] values;

    private IntSeq(long[] vals, Type t) {
        super(vals.length, t);
        this.values = vals;
    }

    @Override
    public Int itemAt(long pos) {
        return Int.get(this.values[(int)pos], this.type);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof IntSeq)) {
            return false;
        }
        IntSeq is = (IntSeq)cmp;
        return this.type == is.type && Arrays.equals(this.values, is.values);
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYT: {
                byte[] t1 = new byte[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t1[s] = (byte)this.values[s];
                    ++s;
                }
                return t1;
            }
            case SHR: 
            case UBY: {
                short[] t2 = new short[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t2[s] = (short)this.values[s];
                    ++s;
                }
                return t2;
            }
            case INT: 
            case USH: {
                short[] t3 = new short[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t3[s] = (short)this.values[s];
                    ++s;
                }
                return t3;
            }
        }
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        long[] tmp = new long[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return IntSeq.get(tmp, this.type);
    }

    public static Value get(long[] items, Type type) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Int.get(items[0], type) : new IntSeq(items, type));
    }

    public static Value get(Value[] vals, int size, Type type) throws QueryException {
        long[] tmp = new long[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).itr(null);
                continue;
            }
            if (val instanceof IntSeq) {
                IntSeq sq = (IntSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).itr(null);
            }
        }
        return IntSeq.get(tmp, type);
    }
}

