/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class StrSeq
extends NativeSeq {
    private final byte[][] values;

    private StrSeq(byte[][] vals) {
        super(vals.length, (Type)AtomType.STR);
        this.values = vals;
    }

    @Override
    public Str itemAt(long pos) {
        return Str.get(this.values[(int)pos]);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof StrSeq && Arrays.equals((Object[])this.values, (Object[])((StrSeq)cmp).values);
    }

    public String[] toJava() {
        String[] tmp = new String[this.values.length];
        for (int v = 0; v < this.values.length; ++v) {
            tmp[v] = Token.string(this.values[v]);
        }
        return tmp;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        byte[][] tmp = new byte[s][];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return StrSeq.get(tmp);
    }

    public static Value get(TokenList items) {
        return items.isEmpty() ? Empty.SEQ : (items.size() == 1 ? Str.get(items.get(0)) : new StrSeq(items.toArray()));
    }

    public static Value get(byte[][] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Str.get(items[0]) : new StrSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        byte[][] tmp = new byte[size][];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).string(null);
                continue;
            }
            if (val instanceof StrSeq) {
                StrSeq sq = (StrSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).string(null);
            }
        }
        return StrSeq.get(tmp);
    }
}

