/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.StaticDecl;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class StaticVar
extends StaticDecl {
    private static final QNm LAZY = new QNm("lazy", QueryText.BASEXURI);
    private final boolean external;
    Value value;
    private final boolean lazy;

    StaticVar(StaticContext sctx, VarScope scp, Ann a, QNm n, SeqType t, Expr e, boolean ext, String xqdoc, InputInfo ii) {
        super(sctx, a, n, t, scp, xqdoc, ii);
        this.expr = e;
        this.external = ext;
        this.lazy = this.ann.contains(LAZY);
    }

    @Override
    public void compile(QueryContext ctx) throws QueryException {
        if (this.expr == null) {
            throw Err.VAREMPTY.get(this.info, '$' + Token.string(this.name.string()));
        }
        if (this.dontEnter) {
            throw Err.circVarError(this);
        }
        if (!this.compiled) {
            this.dontEnter = true;
            try {
                this.expr = this.expr.compile(ctx, this.scope);
            }
            catch (QueryException qe) {
                this.compiled = true;
                if (this.lazy) {
                    this.expr = FNInfo.error(qe, this.expr.type());
                    return;
                }
                throw qe.notCatchable();
            }
            finally {
                this.scope.cleanUp(this);
                this.dontEnter = false;
            }
            this.compiled = true;
            if (!this.lazy || this.expr.isValue()) {
                this.bind(this.value(ctx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value value(QueryContext ctx) throws QueryException {
        if (this.dontEnter) {
            throw Err.circVarError(this);
        }
        if (this.lazy) {
            if (!this.compiled) {
                throw Util.notExpected(this + " was not compiled.");
            }
            if (this.value != null) {
                return this.value;
            }
            this.dontEnter = true;
            int fp = this.scope.enter(ctx);
            try {
                Value value = this.bind(this.expr.value(ctx));
                return value;
            }
            catch (QueryException qe) {
                throw qe.notCatchable();
            }
            finally {
                this.scope.exit(ctx, fp);
                this.dontEnter = false;
            }
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.expr == null) {
            throw Err.VAREMPTY.get(this.info, this);
        }
        this.dontEnter = true;
        int fp = this.scope.enter(ctx);
        try {
            Value value = this.bind(this.expr.value(ctx));
            return value;
        }
        finally {
            this.scope.exit(ctx, fp);
            this.dontEnter = false;
        }
    }

    public void checkUp() throws QueryException {
        if (this.expr != null && this.expr.has(Expr.Flag.UPD)) {
            throw Err.UPNOT.get(this.info, this.description());
        }
    }

    public boolean bind(Expr e, QueryContext ctx) throws QueryException {
        if (!this.external || this.compiled) {
            return false;
        }
        if (e instanceof Value) {
            Value v = (Value)e;
            if (this.declType != null && !this.declType.instance(v)) {
                v = this.declType.cast(v, ctx, this.sc, this.info, (ExprInfo)e);
            }
            this.bind(v);
        } else {
            this.expr = this.checkType(e, this.info);
            this.value = null;
        }
        return true;
    }

    private Expr checkType(Expr e, InputInfo ii) throws QueryException {
        if (this.declType != null) {
            if (e instanceof Value) {
                this.declType.treat((Value)e, ii);
            } else if (e.type().intersect(this.declType) == null) {
                throw Err.treatError(ii, this.declType, e);
            }
        }
        return e;
    }

    private Value bind(Value v) throws QueryException {
        this.expr = v;
        this.value = this.declType != null ? this.declType.treat(v, this.info) : v;
        return this.value;
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(QueryText.NAM, this.name.string());
        if (this.expr != null) {
            this.expr.plan(e);
        }
        plan.add(e);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr == null || this.expr.accept(visitor);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("declare").append(' ');
        if (!this.ann.isEmpty()) {
            sb.append(this.ann);
        }
        sb.append("variable").append(' ').append("$").append(Token.string(this.name.string())).append(' ');
        if (this.declType != null) {
            sb.append("as").append(' ').append(this.declType).append(' ');
        }
        if (this.expr != null) {
            sb.append(":=").append(' ').append(this.expr);
        } else {
            sb.append("external");
        }
        return sb.append(';').toString();
    }

    @Override
    public byte[] id() {
        return Token.concat(new byte[]{36}, this.name.id());
    }

    public boolean has(Expr.Flag flag) {
        if (this.dontEnter || this.expr == null) {
            return false;
        }
        this.dontEnter = true;
        boolean res = this.expr.has(flag);
        this.dontEnter = false;
        return res;
    }
}

