/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Proc;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.Performance;
import org.basex.util.Util;

final class QueryListener
extends Proc {
    private final Performance perf = new Performance();
    private final String query;
    private final Context ctx;
    private QueryProcessor qp;
    private SerializerOptions parameters;
    private boolean parsed;
    private String info = "";

    QueryListener(String qu, Context c) {
        this.query = qu;
        this.ctx = c;
    }

    void bind(String n, Object v, String t) throws IOException {
        try {
            this.init().bind(n, v, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    void context(Object v, String t) throws IOException {
        try {
            this.init().context(v, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    String info() {
        return this.info;
    }

    String parameters() throws IOException {
        if (this.parameters == null) {
            this.parameters = this.parse().ctx.serParams();
        }
        return this.parameters.toString();
    }

    boolean updating() throws IOException {
        return this.parse().updating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(boolean iter, OutputStream out, boolean enc, boolean full) throws IOException {
        try {
            try {
                Item it;
                this.ctx.register(this.parse());
                this.qp.compile();
                QueryInfo qi = this.qp.ctx.info;
                qi.compiling = this.perf.time();
                Iter ir = this.qp.iter();
                qi.evaluating = this.perf.time();
                this.parameters();
                boolean wrap = !this.parameters.get(SerializerOptions.WRAP_PREFIX).isEmpty();
                PrintOutput po = PrintOutput.get(enc ? new EncodingOutput(out) : out);
                if (iter && wrap) {
                    FElem elem = new FElem("");
                    po.write(full ? elem.xdmInfo() : elem.typeId().bytes());
                }
                Serializer ser = Serializer.get(po, full ? null : this.parameters);
                int c = 0;
                while ((it = ir.next()) != null) {
                    if (iter && !wrap) {
                        po.write(full ? it.xdmInfo() : it.typeId().bytes());
                        ser.reset();
                        ser.serialize(it, full, true);
                        po.flush();
                        out.write(0);
                    } else {
                        ser.serialize(it, full, false);
                    }
                    ++c;
                }
                ser.close();
                if (iter && wrap) {
                    out.write(0);
                }
                qi.serializing = this.perf.time();
                this.info = qi.toString(this.qp, po.size(), c, this.ctx.options.get(MainOptions.QUERYINFO));
            }
            catch (QueryException ex) {
                throw new BaseXException(ex);
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                throw new BaseXException(Err.BASX_STACKOVERFLOW.desc, new Object[0]);
            }
            catch (ProcException ex) {
                throw new BaseXException(Text.TIMEOUT_EXCEEDED, new Object[0]);
            }
        }
        finally {
            if (this.qp != null) {
                this.qp.close();
                if (this.parsed) {
                    this.ctx.unregister(this.qp);
                    this.parsed = false;
                }
                this.qp = null;
            }
        }
    }

    private QueryProcessor parse() throws IOException {
        if (!this.parsed) {
            try {
                this.perf.time();
                this.init().parse();
                this.qp.ctx.info.parsing = this.perf.time();
                this.parsed = true;
            }
            catch (QueryException ex) {
                throw new BaseXException(ex);
            }
        }
        return this.qp;
    }

    private QueryProcessor init() {
        if (this.parsed || this.qp == null) {
            this.qp = new QueryProcessor(this.query, this.ctx);
            this.parsed = false;
        }
        return this.qp;
    }
}

