/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

public final class Performance {
    private long time = System.nanoTime();

    public long time() {
        long time2 = System.nanoTime();
        long diff = time2 - this.time;
        this.time = time2;
        return diff;
    }

    public String getTime() {
        return this.getTime(1);
    }

    public String getTime(int runs) {
        long time2 = System.nanoTime();
        String t = Performance.getTime(time2 - this.time, runs);
        this.time = time2;
        return t;
    }

    public static String getTime(long time, int runs) {
        return (double)Math.round((double)time / 10000.0 / (double)runs) / 100.0 + " ms" + (runs > 1 ? " (avg)" : "");
    }

    public static String getMemory() {
        return Performance.format(Performance.memory());
    }

    public static String format(long size) {
        return Performance.format(size, true, 5);
    }

    public static String format(long size, boolean det) {
        return Performance.format(size, det, 0);
    }

    private static String format(long size, boolean det, int off) {
        if (size >= 1L << 50 + off) {
            return (size + 0x2000000000000L >> 50) + " PB";
        }
        if (size >= 1L << 40 + off) {
            return (size + 0x8000000000L >> 40) + " TB";
        }
        if (size >= 1L << 30 + off) {
            return (size + 0x20000000L >> 30) + " GB";
        }
        if (size >= 1L << 20 + off) {
            return (size + 524288L >> 20) + " MB";
        }
        if (size >= 1L << 10 + off) {
            return (size + 512L >> 10) + " KB";
        }
        return size + (det ? " Byte" + (size == 1L ? "" : "s") : " B");
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(Math.max(0L, ms));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void gc(int n) {
        for (int i = 0; i < n; ++i) {
            System.gc();
        }
    }

    public static long memory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public String toString() {
        return this.getTime();
    }
}

