/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TokenBuilder {
    public static final byte HLINE = 1;
    public static final byte BOLD = 2;
    public static final byte NORM = 3;
    public static final byte MARK = 4;
    public static final byte ULINE = 5;
    public static final byte NLINE = 10;
    private byte[] chars;
    private int size;

    public TokenBuilder() {
        this(8);
    }

    public TokenBuilder(int capacity) {
        this.chars = new byte[capacity];
    }

    public TokenBuilder(String string) {
        this(Token.token(string));
    }

    public TokenBuilder(byte[] token) {
        this(token.length + 8);
        this.size = token.length;
        System.arraycopy(token, 0, this.chars, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public void size(int s) {
        this.size = s;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public TokenBuilder reset() {
        this.size = 0;
        return this;
    }

    public TokenBuilder bold() {
        return this.addByte((byte)2);
    }

    public TokenBuilder uline() {
        return this.addByte((byte)5);
    }

    public TokenBuilder norm() {
        return this.addByte((byte)3);
    }

    public TokenBuilder nline() {
        return this.addByte((byte)10);
    }

    public TokenBuilder hline() {
        return this.addByte((byte)1);
    }

    public TokenBuilder add(int cp) {
        if (cp <= 127) {
            this.addByte((byte)cp);
        } else if (cp <= 2047) {
            this.addByte((byte)(cp >> 6 & 0x1F | 0xC0));
            this.addByte((byte)(cp & 0x3F | 0x80));
        } else if (cp <= 65535) {
            this.addByte((byte)(cp >> 12 & 0xF | 0xE0));
            this.addByte((byte)(cp >> 6 & 0x3F | 0x80));
            this.addByte((byte)(cp & 0x3F | 0x80));
        } else {
            this.addByte((byte)(cp >> 18 & 7 | 0xF0));
            this.addByte((byte)(cp >> 12 & 0x3F | 0x80));
            this.addByte((byte)(cp >> 6 & 0x3F | 0x80));
            this.addByte((byte)(cp & 0x3F | 0x80));
        }
        return this;
    }

    public TokenBuilder insert(int pos, int cp) {
        int l;
        int s = this.size;
        int cl = this.chars.length;
        int n = cp <= 127 ? 1 : (cp <= 2047 ? 2 : (l = cp <= 4095 ? 3 : 4));
        if (s + l > cl) {
            int ns = Math.max(s + l, (int)((double)cl * 1.5));
            this.chars = Arrays.copyOf(this.chars, ns);
        }
        Array.move(this.chars, pos, l, this.size - pos);
        this.size = pos;
        this.add(cp);
        this.size = s + l;
        return this;
    }

    public int cp(int pos) {
        return Token.cp(this.chars, pos);
    }

    public int cl(int pos) {
        return Token.cl(this.chars, pos);
    }

    public byte get(int pos) {
        return this.chars[pos];
    }

    public void set(int pos, byte value) {
        this.chars[pos] = value;
    }

    public void delete(int pos, int length) {
        Array.move(this.chars, pos + length, -length, this.size - pos - length);
        this.size -= length;
    }

    public TokenBuilder addByte(byte value) {
        if (this.size == this.chars.length) {
            this.chars = Arrays.copyOf(this.chars, Array.newSize(this.size));
        }
        this.chars[this.size++] = value;
        return this;
    }

    public TokenBuilder addInt(int value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder addLong(long value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder add(byte[] value) {
        return this.add(value, 0, value.length);
    }

    public TokenBuilder add(byte[] value, int start, int end) {
        int l = end - start;
        int cl = this.chars.length;
        if (this.size + l > cl) {
            int ns = Math.max(this.size + l, (int)((double)cl * 1.5));
            this.chars = Arrays.copyOf(this.chars, ns);
        }
        System.arraycopy(value, start, this.chars, this.size, l);
        this.size += l;
        return this;
    }

    public TokenBuilder add(String string) {
        return this.add(Token.token(string));
    }

    public TokenBuilder addSep(Object[] objects, String sep) {
        for (int e = 0; e != objects.length; ++e) {
            if (e != 0) {
                this.add(sep);
            }
            this.addExt(objects[e], new Object[0]);
        }
        return this;
    }

    public TokenBuilder addExt(Object object, Object ... ext) {
        byte[] t;
        if (object instanceof byte[]) {
            t = (byte[])object;
        } else {
            String s = object == null ? "null" : (object instanceof Throwable ? Util.message((Throwable)object) : (object instanceof Class ? Util.className((Class)object) : object.toString()));
            t = Token.token(s);
        }
        int e = 0;
        for (int i = 0; i < t.length; ++i) {
            boolean d;
            if (t[i] != 37 || e == ext.length) {
                this.addByte(t[i]);
                continue;
            }
            byte c = i + 1 < t.length ? t[i + 1] : (byte)0;
            boolean bl = d = c >= 49 && c <= 57;
            if (d) {
                ++i;
            }
            int n = d ? c - 49 : e++;
            Object o = n < ext.length ? ext[n] : null;
            this.addExt(o, new Object[0]);
        }
        return this;
    }

    public TokenBuilder trim() {
        while (this.size > 0 && Token.ws(this.chars[this.size - 1])) {
            --this.size;
        }
        int s = -1;
        while (++s < this.size && Token.ws(this.chars[s])) {
        }
        if (s != 0 && s != this.size) {
            Array.move(this.chars, s, -s, this.size - s);
        }
        this.size -= s;
        return this;
    }

    public byte[] finish() {
        return Arrays.copyOf(this.chars, this.size);
    }

    public byte[] array() {
        return this.size == this.chars.length ? this.chars : this.finish();
    }

    public String toString() {
        return Token.string(this.chars, 0, this.size);
    }
}

