/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.list.ElementList;

public final class BoolList
extends ElementList {
    private boolean[] list;

    public BoolList() {
        this(8);
    }

    private BoolList(int capacity) {
        this.list = new boolean[capacity];
    }

    public void add(boolean element) {
        if (this.size == this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = element;
    }

    public boolean get(int index) {
        return this.list[index];
    }

    public void set(int index, boolean element) {
        if (index >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public boolean pop() {
        return this.list[--this.size];
    }

    public void push(boolean element) {
        this.add(element);
    }

    public boolean peek() {
        return this.list[this.size - 1];
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

