/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.list.ElementList;

public class StringList
extends ElementList
implements Iterable<String> {
    protected String[] list;

    public StringList() {
        this(8);
    }

    public StringList(int capacity) {
        this.list = new String[capacity];
    }

    public StringList(String ... elements) {
        this.list = elements;
        this.size = elements.length;
    }

    public final StringList add(String e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
        return this;
    }

    public final StringList add(String ... elements) {
        for (String s : elements) {
            this.add(s);
        }
        return this;
    }

    public final StringList add(StringList elements) {
        for (String s : elements) {
            this.add(s);
        }
        return this;
    }

    public final String get(int index) {
        return this.list[index];
    }

    public final void set(int index, String element) {
        if (index >= this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public final boolean contains(String element) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.list[i].equals(element)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(StringList elements) {
        if (this.isEmpty() && !elements.isEmpty()) {
            return false;
        }
        int i = 0;
        for (String e : elements) {
            int result;
            while ((result = this.list[i].compareTo(e)) != 0) {
                if (++i < this.size() && result <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public final String deleteAt(int index) {
        String l = this.list[index];
        Array.move(this.list, index + 1, -1, --this.size - index);
        return l;
    }

    public final void delete(String element) {
        int s = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.list[i].equals(element)) continue;
            this.list[s++] = this.list[i];
        }
        this.size = s;
    }

    public final String[] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public final StringList sort(boolean cs) {
        return this.sort(cs, true, 0);
    }

    public final StringList sort(boolean cs, boolean asc) {
        return this.sort(cs, asc, 0);
    }

    public final StringList sort(boolean cs, boolean asc, int index) {
        Comparator comp = cs ? null : String.CASE_INSENSITIVE_ORDER;
        Arrays.sort(this.list, index, this.size, asc ? comp : Collections.reverseOrder(comp));
        return this;
    }

    public StringList unique() {
        if (this.size != 0) {
            int s = 0;
            for (int l = 1; l < this.size; ++l) {
                if (this.list[l].equals(this.list[s])) continue;
                this.list[++s] = this.list[l];
            }
            this.size = s + 1;
        }
        return this;
    }

    @Override
    public final Iterator<String> iterator() {
        return new ArrayIterator<String>(this.list, this.size);
    }

    public final String toString() {
        return Arrays.toString(this.toArray());
    }
}

