import java.net.*;
import java.io.*;
import java.util.*;

public class HTTPServer
{
	int serverPort=80;
	String serverRoot="";
	String defaultFile="default.htm";
	int delay=0;

	public static void main(String args[])
	{
		HTTPServer server=new HTTPServer();
		if (args.length>0) server.processCommandLine(args);
		server.run();
	}

	public HTTPServer() {super();}

	public void processCommandLine(String[] args)
	{
		for (int i=0;i<args.length;i+=2)
		{
			if (args[i].equalsIgnoreCase("-port")&&i+1<args.length) serverPort=Integer.valueOf(args[i+1]).intValue();
			else if (args[i].equalsIgnoreCase("-root")&&i+1<args.length) serverRoot=args[i+1];
			else if (args[i].equalsIgnoreCase("-default")&&i+1<args.length) defaultFile=args[i+1];
			else if (args[i].equalsIgnoreCase("-delay")&&i+1<args.length) delay=Integer.valueOf(args[i+1]).intValue();
			else --i;
		}
	}

	public void run()
	{
	        System.out.println("HTTPServer version 2.0 by CJA, based on code from Java 2 Unleashed");
		System.out.println("  serverPort: "+serverPort);
		System.out.println("  serverRoot: "+serverRoot);
		System.out.println("  defaultFile: "+defaultFile);
		try
		{
			ServerSocket server=new ServerSocket(serverPort);
			int localPort=server.getLocalPort();
			datedLog("HTTPServer is listening on port "+localPort+".");
			do
			{
				Socket client=server.accept();
				(new ServerThread(client,serverPort,serverRoot,defaultFile,delay)).start();
			} while(true);
		} catch (IOException ex) {datedLog("Unable to listen on "+serverPort+"."); System.exit(0);}
	}

	public synchronized void datedLog(String msg)
	{
		System.out.println((new Date()).toString()+" "+msg);
	}
}
