/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.cvs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.Hashtable;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.jigedit.cvs.CvsFrame;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.frames.PostableFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.Utils;

public class CvsEntryResource
extends ContainerResource {
    protected String name = null;
    protected ResourceReference rr_cvsframe = null;
    static byte[] startAnchor = new byte[]{60, 97, 32, 104, 114, 101, 102, 61, 34};
    static byte[] midAnchor = new byte[]{34, 62};
    static byte[] endAnchor = new byte[]{60, 47, 97, 62};
    static byte[] edittext = new byte[]{101, 100, 105, 116, 32, 108, 111, 103};
    static byte[] pattern = new byte[]{114, 101, 118, 105, 115, 105, 111, 110};
    static byte[] increments = new byte[128];
    private DummyResourceReference self = null;
    private Hashtable revisions = new Hashtable(3);
    private CvsDirectory cvs = null;

    protected int getMinor(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CvsDirectory getCvsManager() throws InvalidResourceException {
        if (this.cvs == null) {
            try {
                CvsFrame cvsFrame = (CvsFrame)this.rr_cvsframe.lock();
                this.cvs = cvsFrame.getCvsManager();
            }
            finally {
                this.rr_cvsframe.unlock();
            }
        }
        return this.cvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCvsURL() {
        String string = null;
        try {
            CvsFrame cvsFrame = (CvsFrame)this.rr_cvsframe.lock();
            string = cvsFrame.getResource().getURLPath();
        }
        catch (InvalidResourceException invalidResourceException) {
            String string2 = null;
            return string2;
        }
        finally {
            this.rr_cvsframe.unlock();
        }
        return string;
    }

    protected void checkRevisionNumber(String string) throws RevisionNumberException, CvsException {
        try {
            String string2 = this.getCvsManager().revision(this.name);
            if (string2 == null) {
                return;
            }
            int n = this.getMinor(string2);
            int n2 = this.getMinor(string);
            if (n2 > n || n2 <= 0) {
                throw new RevisionNumberException(string);
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            throw new RevisionNumberException("Unable to check revision number, CvsFrame invalid.");
        }
        finally {
            this.rr_cvsframe.unlock();
        }
    }

    static final boolean byteArrayNEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n3 + n;
        for (int i = n; i < n5; ++i) {
            if (byArray[i] == byArray2[i + n4]) continue;
            return false;
        }
        return true;
    }

    static final boolean isDigitOrPoint(byte by) {
        return by == 46 || by == 48 || by == 49 || by == 50 || by == 51 || by == 52 || by == 53 || by == 54 || by == 55 || by == 56 || by == 57;
    }

    static final boolean isSpace(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13;
    }

    protected void writeLinks(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(startAnchor);
        outputStream.write(("./" + this.name + "/").getBytes());
        outputStream.write(byArray, n, n2);
        outputStream.write(midAnchor);
        outputStream.write(byArray, n, n2);
        outputStream.write(endAnchor);
        outputStream.write(32);
        outputStream.write(91);
        outputStream.write(startAnchor);
        outputStream.write(("./" + this.name + "?editlog=").getBytes());
        outputStream.write(byArray, n, n2);
        outputStream.write(midAnchor);
        outputStream.write(edittext);
        outputStream.write(endAnchor);
        outputStream.write(93);
    }

    protected String parseDiff(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(60);
        if (n == -1) {
            return string;
        }
        while ((n = string.indexOf(60)) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("&lt;");
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected HtmlGenerator parseLog(String string) {
        int n;
        HtmlGenerator htmlGenerator = this.getHtmlGenerator("CVS log of " + this.name);
        String string2 = this.getCvsURL();
        String string3 = "[ <a href=\"./../\">Up to directory</a> ] &middot; [ <a href=\"" + string2 + "\">Back to CVS</a> ]";
        htmlGenerator.append("<center>", string3, "<hr noshade width=\"80%\"></center><p>");
        htmlGenerator.append("<span class=\"title\"> CVS log of ", this.name, "</span>\n");
        htmlGenerator.append("<div class=\"box\"><pre>\n");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = string.getBytes();
        int n2 = 0;
        int n3 = 0;
        n2 += 7;
        while (true) {
            byte by;
            if (!(n2 >= byArray.length || (by = byArray[n2]) == 110 && CvsEntryResource.byteArrayNEquals(byArray, n2 - 7, pattern, 0, 7))) {
                n2 += increments[by >= 0 ? by : (byte)0];
                continue;
            }
            if (++n2 >= byArray.length) break;
            while (n2 <= byArray.length && CvsEntryResource.isSpace(byArray[n2])) {
                ++n2;
            }
            byteArrayOutputStream.write(byArray, n3, n2 - n3);
            n3 = n2;
            while (n2 <= byArray.length && CvsEntryResource.isDigitOrPoint(byArray[n2])) {
                ++n2;
            }
            if (n2 - 1 > n3) {
                String string4 = new String(byArray, n3, n2 - n3);
                try {
                    this.checkRevisionNumber(string4);
                    this.writeLinks(byteArrayOutputStream, byArray, n3, n2 - n3);
                }
                catch (Exception exception) {
                    byteArrayOutputStream.write(byArray, n3, n2 - n3);
                }
            }
            n3 = n2;
            if (n2 >= byArray.length) break;
        }
        if ((n = byArray.length - n3 - 1) > 0) {
            byteArrayOutputStream.write(byArray, n3, n);
        }
        String string5 = byteArrayOutputStream.toString();
        htmlGenerator.append(string5);
        htmlGenerator.append("\n</pre></div>\n");
        htmlGenerator.append("<hr noshade width=\"80%\"><center>", string3, "</center><p>");
        return htmlGenerator;
    }

    protected synchronized ResourceReference getRevisionResource(String string) {
        RevisionResource revisionResource = (RevisionResource)((Object)this.revisions.get(string));
        if (revisionResource == null) {
            revisionResource = new RevisionResource(string);
            this.revisions.put(string, revisionResource);
        }
        return revisionResource.getResourceReference();
    }

    public ResourceReference lookup(String string) {
        try {
            this.checkRevisionNumber(string);
            return this.getRevisionResource(string);
        }
        catch (CvsException cvsException) {
        }
        catch (RevisionNumberException revisionNumberException) {
            // empty catch block
        }
        return null;
    }

    public synchronized ResourceReference getResourceReference() {
        if (this.self == null) {
            this.self = new DummyResourceReference((Resource)this);
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HtmlGenerator getHtmlGenerator(String string) {
        try {
            CvsFrame cvsFrame = (CvsFrame)this.rr_cvsframe.lock();
            HtmlGenerator htmlGenerator = CvsFrame.getHtmlGenerator(cvsFrame, string);
            return htmlGenerator;
        }
        catch (InvalidResourceException invalidResourceException) {
            HtmlGenerator htmlGenerator = CvsFrame.getHtmlGenerator(string);
            return htmlGenerator;
        }
        finally {
            this.rr_cvsframe.unlock();
        }
    }

    CvsEntryResource(ResourceReference resourceReference, String string) {
        this.name = string;
        this.rr_cvsframe = resourceReference;
        Hashtable hashtable = new Hashtable(3);
        this.registerFrame((ResourceFrame)new CvsEntryFrame(), hashtable);
    }

    static {
        for (int i = 0; i < 128; ++i) {
            CvsEntryResource.increments[i] = 8;
        }
        CvsEntryResource.increments[114] = 7;
        CvsEntryResource.increments[101] = 6;
        CvsEntryResource.increments[118] = 5;
        CvsEntryResource.increments[105] = 2;
        CvsEntryResource.increments[115] = 3;
        CvsEntryResource.increments[111] = 1;
    }

    class CvsEntryFrame
    extends PostableFrame {
        CvsEntryFrame() {
        }

        protected Reply dolog(Request request) throws ProtocolException {
            String string = null;
            try {
                string = CvsEntryResource.this.getCvsManager().log(CvsEntryResource.this.name);
            }
            catch (CvsException cvsException) {
                Reply reply = request.makeReply(500);
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS log command failed");
                htmlGenerator.append("<p>The CVS <strong>log</strong> command failed  on " + CvsEntryResource.this.name + " with the following error message: " + "<em>" + cvsException.getMessage() + "</em>" + "<hr> from class: " + ((Object)((Object)this)).getClass().getName());
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
            catch (InvalidResourceException invalidResourceException) {
                Reply reply = request.makeReply(500);
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS log command failed");
                htmlGenerator.append("<p>The CVS <strong>log</strong> command failed  on " + CvsEntryResource.this.name + " with the following error message: " + "<em>" + invalidResourceException.getMessage() + "</em>" + "<hr> from class: " + ((Object)((Object)this)).getClass().getName());
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
            finally {
                CvsEntryResource.this.rr_cvsframe.unlock();
            }
            Reply reply = request.makeReply(200);
            reply.setContentType(MimeType.TEXT_HTML);
            reply.setStream(CvsEntryResource.this.parseLog(string));
            return reply;
        }

        protected Reply dodiff(Request request) throws HTTPException {
            String string = null;
            try {
                string = CvsEntryResource.this.getCvsManager().diff(CvsEntryResource.this.name);
            }
            catch (CvsException cvsException) {
                Reply reply = request.makeReply(500);
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS diff command failed");
                htmlGenerator.append("<p>The CVS <strong>diff</strong> command failed  on " + CvsEntryResource.this.name + " with the following error message: " + "<em>" + cvsException.getMessage() + "</em>" + "<hr> from class: " + ((Object)((Object)this)).getClass().getName());
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
            catch (InvalidResourceException invalidResourceException) {
                Reply reply = request.makeReply(500);
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS diff command failed");
                htmlGenerator.append("<p>The CVS <strong>diff</strong> command failed  on " + CvsEntryResource.this.name + " with the following error message: " + "<em>" + invalidResourceException.getMessage() + "</em>" + "<hr> from class: " + ((Object)((Object)this)).getClass().getName());
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
            finally {
                CvsEntryResource.this.rr_cvsframe.unlock();
            }
            Reply reply = request.makeReply(200);
            if (string == null || string.length() == 0) {
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS diff command results");
                htmlGenerator.append("<P>No differences between " + CvsEntryResource.this.name + " and the repository</P>");
                reply.setStream(htmlGenerator);
            } else {
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("Diff result");
                htmlGenerator.append("<center>");
                htmlGenerator.append(" [ <a href=\"../\">Up to directory</A> ] &middot;");
                htmlGenerator.append(" [ <a href=\"" + CvsEntryResource.this.getCvsURL(), "\">Back to CVS</A> ] \n");
                htmlGenerator.append("</center>");
                htmlGenerator.append("<hr noshade width=\"80%\"><p>");
                htmlGenerator.append("<span class=\"title\"> CVS diff of ", CvsEntryResource.this.name, "</span>\n");
                htmlGenerator.append("<pre>", CvsEntryResource.this.parseDiff(string), "</pre>\n");
                htmlGenerator.append("<p><hr noshade width=\"80%\">");
                htmlGenerator.append("<center>");
                htmlGenerator.append(" [ <a href=\"../\">Up to directory</A> ] &middot;");
                htmlGenerator.append(" [ <a href=\"" + CvsEntryResource.this.getCvsURL(), "\">Back to CVS</A> ] \n");
                htmlGenerator.append("</center>");
                reply.setStream(htmlGenerator);
            }
            return reply;
        }

        protected Reply doEditRev(Request request, String string) throws HTTPException {
            HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("Edit log");
            htmlGenerator.append("<center>");
            htmlGenerator.append(" [ <a href=\"../\">Up to directory</A> ] &middot; ");
            htmlGenerator.append(" [ <a href=\"" + CvsEntryResource.this.getCvsURL() + "\">Back to CVS</A> ] &middot; ");
            htmlGenerator.append(" [ <a href=\"./", CvsEntryResource.this.name + "?log\">Back to log</A> ] ");
            htmlGenerator.append("<hr noshade width=\"80%\"><p>");
            htmlGenerator.append("<span class=\"title\"> Edit log comment of ", CvsEntryResource.this.name, " (revision " + string + ")</span>\n");
            htmlGenerator.append("<form  method=\"post\">\n");
            htmlGenerator.append("<input type=\"hidden\" name=\"revision\" value=\"", string, "\">\n");
            htmlGenerator.append("<table border=\"0\">\n");
            htmlGenerator.append("<tr><td align=\"left\">");
            htmlGenerator.append("<textarea name=\"comment\" rows=\"3\" cols=\"50\">\n");
            htmlGenerator.append("</textarea></td></tr>\n");
            htmlGenerator.append("</td></tr><tr><td align=\"center\">");
            htmlGenerator.append("<input type=\"submit\" name=\"submit\" value=\" Save Comment \">");
            htmlGenerator.append("</td></tr>");
            htmlGenerator.append("</table></center></form>\n");
            htmlGenerator.append("<hr noshade width=\"80%\">");
            Reply reply = request.makeReply(200);
            reply.setStream(htmlGenerator);
            return reply;
        }

        protected String getRevisionToEdit(Request request) throws HTTPException {
            String string = request.getQueryString();
            if (string == null) {
                return null;
            }
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            URLDecoder uRLDecoder = new URLDecoder((InputStream)stringBufferInputStream, this.getOverrideFlag());
            try {
                uRLDecoder.parse();
            }
            catch (URLDecoderException uRLDecoderException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to decode form data.");
                throw new HTTPException(reply);
            }
            catch (IOException iOException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to read form data.");
                throw new HTTPException(reply);
            }
            return uRLDecoder.getValue("editlog");
        }

        public Reply get(Request request) throws ProtocolException {
            if (!request.hasState("query")) {
                Reply reply = request.makeReply(500);
                reply.setContent("Invalid query field.");
                throw new HTTPException(reply);
            }
            String string = request.getQueryString();
            if (string.equalsIgnoreCase("log")) {
                return this.dolog(request);
            }
            if (string.equalsIgnoreCase("diff")) {
                return this.dodiff(request);
            }
            String string2 = this.getRevisionToEdit(request);
            if (string2 != null) {
                return this.doEditRev(request, string2);
            }
            Reply reply = request.makeReply(500);
            reply.setContent("Unknown command: " + string);
            throw new HTTPException(reply);
        }

        public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
            String string = uRLDecoder.getValue("revision");
            String string2 = uRLDecoder.getValue("comment");
            if (string == null) {
                Reply reply = request.makeReply(500);
                reply.setContent("No revision selected !");
                throw new HTTPException(reply);
            }
            if (string2 == null) {
                Reply reply = request.makeReply(400);
                reply.setContent("Empty comment not allowed.");
                throw new HTTPException(reply);
            }
            try {
                String[] stringArray = new String[]{"-m" + string + ":\"" + string2 + "\"", CvsEntryResource.this.name};
                CvsEntryResource.this.getCvsManager().admin(stringArray);
            }
            catch (CvsException cvsException) {
                Reply reply = request.makeReply(500);
                HtmlGenerator htmlGenerator = CvsEntryResource.this.getHtmlGenerator("CVS admin command failed");
                htmlGenerator.append("<p>The CVS <strong>admin</strong> command failed  on " + CvsEntryResource.this.name + " with the following error message: " + "<em>" + cvsException.getMessage() + "</em>");
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
            catch (InvalidResourceException invalidResourceException) {
                Reply reply = request.makeReply(500);
                reply.setContent("CvsFrame invalid");
                return reply;
            }
            return this.dolog(request);
        }
    }

    class RevisionFrame
    extends HTTPFrame {
        String revision = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected synchronized void updateHeaders() {
            try {
                CvsFrame cvsFrame = (CvsFrame)CvsEntryResource.this.rr_cvsframe.lock();
                FramedResource framedResource = cvsFrame.getResource();
                ResourceReference resourceReference = framedResource.getParent();
                try {
                    Resource resource = resourceReference.lock();
                    if (!(resource instanceof ContainerResource)) return;
                    ContainerResource containerResource = (ContainerResource)resource;
                    ResourceReference resourceReference2 = containerResource.lookup(CvsEntryResource.this.name);
                    if (resourceReference2 == null) {
                        this.setValue(ATTR_CONTENT_TYPE, Utils.getMimeType((String)CvsEntryResource.this.name));
                        return;
                    }
                    try {
                        framedResource = resourceReference2.lock();
                        if (!(framedResource instanceof FileResource)) return;
                        HTTPFrame hTTPFrame = (HTTPFrame)framedResource.getFrame(Class.forName("org.w3c.jigsaw.frames.HTTPFrame"));
                        this.setValue(ATTR_CONTENT_LANGUAGE, hTTPFrame.getContentLanguage());
                        this.setValue(ATTR_CONTENT_ENCODING, hTTPFrame.getContentEncoding());
                        this.setValue(ATTR_CONTENT_TYPE, hTTPFrame.getContentType());
                        return;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        return;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return;
                    }
                    finally {
                        resourceReference2.unlock();
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    return;
                }
                finally {
                    resourceReference.unlock();
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                return;
            }
            finally {
                CvsEntryResource.this.rr_cvsframe.unlock();
            }
        }

        public Reply createDefaultReply(Request request, int n) {
            Reply reply = super.createDefaultReply(request, n);
            HttpInteger httpInteger = HttpFactory.makeInteger((int)this.getInt(ATTR_CONTENT_LENGTH, -1));
            reply.setHeaderValue(Reply.H_CONTENT_LENGTH, (HeaderValue)httpInteger);
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reply get(Request request) throws ProtocolException {
            Reply reply;
            try {
                CvsEntryResource.this.checkRevisionNumber(this.revision);
            }
            catch (RevisionNumberException revisionNumberException) {
                Reply reply2 = request.makeReply(400);
                reply2.setContent("Bad revision number : <b>" + revisionNumberException.getMessage() + "</b>");
                return reply2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                CvsEntryResource.this.getCvsManager().revert(CvsEntryResource.this.name, (OutputStream)byteArrayOutputStream, this.revision, null);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.setValue(ATTR_CONTENT_LENGTH, new Integer(byArray.length));
                Reply reply3 = this.createDefaultReply(request, 200);
                reply3.setStream((InputStream)byteArrayInputStream);
                String string = request.getURL().toString();
                int n = string.lastIndexOf(47);
                int n2 = string.lastIndexOf(47, n - 1);
                int n3 = string.lastIndexOf(47, n2 - 1);
                String string2 = string.substring(0, n3);
                reply3.setContentLocation(string2 + '/' + CvsEntryResource.this.name);
                reply = reply3;
            }
            catch (InvalidResourceException invalidResourceException) {
                Reply reply4;
                try {
                    Reply reply5 = request.makeReply(500);
                    reply5.setContent("CvsFrame invalid");
                    reply4 = reply5;
                }
                catch (Throwable throwable) {
                    try {
                        CvsEntryResource.this.rr_cvsframe.unlock();
                        throw throwable;
                    }
                    catch (CvsException cvsException) {
                        Reply reply6 = request.makeReply(500);
                        reply6.setContent("Cvs operation failed : <b>" + cvsException.getMessage() + "</b>");
                        return reply6;
                    }
                }
                CvsEntryResource.this.rr_cvsframe.unlock();
                return reply4;
            }
            CvsEntryResource.this.rr_cvsframe.unlock();
            return reply;
        }

        RevisionFrame(String string) {
            this.revision = string;
            this.updateHeaders();
        }
    }

    class RevisionResource
    extends FramedResource {
        ResourceReference rr = null;

        public ResourceReference getResourceReference() {
            if (this.rr == null) {
                this.rr = new DummyResourceReference((Resource)this);
            }
            return this.rr;
        }

        RevisionResource(String string) {
            this.registerFrame((ResourceFrame)new RevisionFrame(string), new Hashtable(3));
        }
    }

    class RevisionNumberException
    extends Exception {
        RevisionNumberException(String string) {
            super(string);
        }
    }
}

