/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.webdav.frames;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.jigedit.cvs.CvsFrame;
import org.w3c.jigedit.cvs.CvsModule;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.webdav.DAVFrame;
import org.w3c.jigsaw.webdav.DAVRequest;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.www.mime.MimeType;

public class CvsDAVDirectoryFrame
extends DAVFrame {
    public static final boolean debug = true;
    private static int ATTR_AUTOUPDATE = -1;
    protected File resDirectory = null;

    protected static Reply error(Request request, int n, String string, String string2) {
        Reply reply = request.makeReply(n);
        HtmlGenerator htmlGenerator = CvsFrame.getHtmlGenerator(string);
        htmlGenerator.append("<span class=\"title\">", string, "</span>\n");
        htmlGenerator.append("<p>", string2);
        reply.setStream(htmlGenerator);
        return reply;
    }

    protected File getResourceDirectory() {
        FramedResource framedResource;
        if (this.resDirectory == null && (framedResource = this.getResource()) instanceof DirectoryResource) {
            this.resDirectory = ((DirectoryResource)framedResource).getDirectory();
        }
        return this.resDirectory;
    }

    public boolean isAutoUpdatable() {
        return this.getBoolean(ATTR_AUTOUPDATE, false);
    }

    protected synchronized CvsDirectory getCvsManager() throws CvsException {
        return CvsModule.getCvsManager(this.getResourceDirectory(), this.getContext(), (Properties)this.getServer().getProperties());
    }

    protected boolean checkCvsManager() {
        try {
            return this.getCvsManager() != null;
        }
        catch (CvsException cvsException) {
            return false;
        }
    }

    protected void add(Request request) throws CvsException {
        String string = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string, "LOGNAME=" + string};
        String[] stringArray2 = null;
        MimeType mimeType = request.getContentType();
        stringArray2 = mimeType != null && mimeType.match(MimeType.TEXT) != 3 && mimeType.match(MimeType.APPLICATION_XHTML_XML) != 4 ? new String[]{"-kb", this.getFileResource().getFile().getName()} : new String[]{this.getFileResource().getFile().getName()};
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.add(stringArray2, stringArray);
    }

    protected void commit(Request request) throws CvsException {
        this.commit(request, "Changed through Jigsaw.");
    }

    protected void commit(Request request, String string) throws CvsException {
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
        String string3 = "(" + string2 + ") " + string;
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.commit(this.getFileResource().getFile().getName(), string3, stringArray);
    }

    protected void update() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        cvsDirectory.update(this.getFileResource().getFile().getName());
    }

    protected int status() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        return cvsDirectory.status(this.getFileResource().getFile().getName());
    }

    protected String statusToString(int n) {
        return CvsDirectory.statusToString((int)n);
    }

    public Reply mkcol(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        Reply reply = super.mkcol(dAVRequest);
        if (reply.getStatus() == 201) {
            String string = (String)dAVRequest.getState("org.w3c.jigsaw.webdav.rpath");
            String[] stringArray = new String[]{string};
            try {
                this.getCvsManager().add(stringArray);
            }
            catch (CvsException cvsException) {
                this.getServer().errlog((Resource)this, cvsException.getMessage());
            }
        }
        return reply;
    }

    public Reply delete(Request request) throws ProtocolException, ResourceException {
        String string = request.getMethod();
        if (string.equals("DELETE")) {
            Reply reply = request.makeReply(403);
            reply.setContent("DELETE is forbidden on CVS controlled directories in this version of JigEdit");
            throw new HTTPException(reply);
        }
        return super.delete(request);
    }

    private void updateStates(DAVRequest dAVRequest) {
        if (this.getCurrentLockDepth() == -1) {
            dAVRequest.setState("org.w3c.jigsaw.webdav.reference", (Object)this.getResourceReference());
            dAVRequest.setState("org.w3c.jigsaw.webdav.owner", (Object)this.getCurrentLockOwner(null));
            dAVRequest.setState("org.w3c.jigsaw.webdav.token", this.getCurrentLockToken(null));
            dAVRequest.setState("org.w3c.jigsaw.webdav.user", this.getCurrentLockUsername(null));
            dAVRequest.setState("org.w3c.jigsaw.webdav.expire", (Object)new Long(this.getTokenExpirationDate(null)));
            dAVRequest.setState("org.w3c.jigsaw.webdav.timeout", this.getValue(ATTR_LOCK_TIMEOUT, DEFAULT_LOCK_TIMEOUT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lookupDirectory(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Object object;
        Object object2;
        DAVRequest dAVRequest = (DAVRequest)lookupState.getRequest();
        if (dAVRequest == null) {
            return super.lookupDirectory(lookupState, lookupResult);
        }
        if (this.isLocked(null)) {
            this.updateStates(dAVRequest);
        }
        if (lookupState.hasMoreComponents()) {
            if (dAVRequest.getMethod().equals("PUT")) {
                object2 = lookupState.peekNextComponent();
                object = this.dresource.lookup((String)object2);
                if (object == null && this.dresource.getExtensibleFlag() && this.getPutableFlag()) {
                    object = lookupState.countRemainingComponents() == 1 ? this.dresource.createResource((String)object2, (RequestInterface)dAVRequest) : this.dresource.createDirectoryResource((String)object2);
                    if (object == null) {
                        Reply reply = dAVRequest.makeReply(415);
                        reply.setContent("Failed to create resource " + (String)object2 + " : " + "Unable to create the appropriate file:" + dAVRequest.getURLPath() + " this media type is not supported");
                        throw new HTTPException(reply);
                    }
                } else if (object == null) {
                    Reply reply = dAVRequest.makeReply(403);
                    reply.setContent("You are not allowed to create resource " + (String)object2 + " : " + this.dresource.getIdentifier() + " is not extensible.");
                    throw new HTTPException(reply);
                }
            } else if (dAVRequest.getMethod().equals("MKCOL") && (object = this.dresource.lookup((String)(object2 = lookupState.peekNextComponent()))) == null) {
                if (lookupState.countRemainingComponents() == 1) {
                    dAVRequest.setState("org.w3c.jigsaw.webdav.rpath", (String)object2);
                    return true;
                }
                Reply reply = dAVRequest.makeReply(409);
                reply.setContent("Can't create " + lookupState.getRemainingPath(true));
                throw new HTTPException(reply);
            }
        }
        if (super.lookupOther(lookupState, lookupResult)) {
            if (!lookupState.isDirectory() && !lookupState.isInternal()) {
                if (dAVRequest == null) {
                    lookupResult.setTarget(null);
                    return true;
                }
                if (!CvsDAVDirectoryFrame.acceptRedirect((DAVRequest)dAVRequest)) {
                    return true;
                }
                object2 = null;
                try {
                    if (dAVRequest != null && dAVRequest.hasState("org.w3c.jigsaw.http.Request.origurl")) {
                        object = (URL)dAVRequest.getState("org.w3c.jigsaw.http.Request.origurl");
                        object2 = new URL((URL)object, ((URL)object).getFile() + "/");
                    } else {
                        object2 = lookupState.hasRequest() ? this.getURL((Request)dAVRequest) : new URL(this.getServer().getURL(), this.resource.getURLPath());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.getServer().errlog((Resource)this, "unable to build full URL.");
                    throw new HTTPException("Internal server error");
                }
                object = "Invalid requested URL: the directory resource  you are trying to reach is available only through  its full URL: <a href=\"" + object2 + "\">" + object2 + "</a>.";
                if (this.getRelocateFlag()) {
                    Reply reply = dAVRequest.makeReply(302);
                    reply.setContent((String)object);
                    reply.setLocation((URL)object2);
                    lookupResult.setTarget(null);
                    lookupResult.setReply((ReplyInterface)reply);
                    return true;
                }
                Reply reply = dAVRequest.makeReply(404);
                reply.setContent((String)object);
                lookupResult.setTarget(null);
                lookupResult.setReply((ReplyInterface)reply);
                return true;
            }
            if (!lookupState.isInternal() && CvsDAVDirectoryFrame.acceptRedirect((DAVRequest)dAVRequest)) {
                dAVRequest.setState("org.w3c.jigsaw.frames.HTTPFrame.cl", "true");
                object2 = this.getIndexes();
                if (object2 != null) {
                    for (int i = 0; i < ((String[])object2).length; ++i) {
                        DirectoryResource directoryResource;
                        ResourceReference resourceReference;
                        String string = object2[i];
                        if (string == null || string.length() <= 0 || (resourceReference = (directoryResource = (DirectoryResource)this.resource).lookup(string)) == null) continue;
                        try {
                            FramedResource framedResource = (FramedResource)resourceReference.lock();
                            boolean bl = framedResource.lookup(lookupState, lookupResult);
                            return bl;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            continue;
                        }
                        finally {
                            resourceReference.unlock();
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    static {
        BooleanAttribute booleanAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.webdav.frames.CvsDAVDirectoryFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        booleanAttribute = new BooleanAttribute("autoupdate", Boolean.FALSE, 2);
        ATTR_AUTOUPDATE = AttributeRegistry.registerAttribute(clazz, (Attribute)booleanAttribute);
    }
}

