/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.attributes;

import java.awt.Dimension;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.EditorFeeder;
import org.w3c.jigadmin.attributes.StringArrayEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.IPTextField;
import org.w3c.tools.widgets.TextEditable;

public class IPTemplateArrayEditor
extends StringArrayEditor {
    protected short[][] oldshortarray = null;

    private String shortsToIPString(short s, short s2, short s3, short s4) {
        return (s == 256 ? "*" : String.valueOf(s)) + "." + (s2 == 256 ? "*" : String.valueOf(s2)) + "." + (s3 == 256 ? "*" : String.valueOf(s3)) + "." + (s4 == 256 ? "*" : String.valueOf(s4));
    }

    protected String[] toStringArray(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        String[] stringArray = new String[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            stringArray[i] = this.shortsToIPString(sArray[i][0], sArray[i][1], sArray[i][2], sArray[i][3]);
        }
        return stringArray;
    }

    protected void setSelectedItems(short[][] sArray) {
        this.comp.setSelectedItems(this.toStringArray(sArray));
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.setSelectedItems(this.oldshortarray);
    }

    public Object getValue() {
        StringTokenizer stringTokenizer = null;
        String[] stringArray = this.comp.getSelectedItems();
        short[][] sArray = new short[stringArray.length][4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringTokenizer = new StringTokenizer(stringArray[i], ".");
            for (int j = 0; j < 4 && stringTokenizer.hasMoreTokens(); ++j) {
                String string = stringTokenizer.nextToken();
                if (string.equals("*")) {
                    sArray[i][j] = 256;
                    continue;
                }
                try {
                    sArray[i][j] = Short.parseShort(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    sArray[i][j] = 0;
                }
            }
        }
        return sArray;
    }

    public void setValue(Object object) {
        this.oldshortarray = (short[][])object;
        this.setSelectedItems(this.oldshortarray);
    }

    protected TextEditable getTextEditor() {
        return new IPTextField();
    }

    protected Dimension getPopupSize() {
        return new Dimension(350, 250);
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        EditorFeeder editorFeeder = null;
        String string = null;
        string = (String)properties.get("feeder.class");
        if (string == null) {
            throw new RuntimeException("StringArrayEditor mis-configuration: feeder.class property undefined.");
        }
        try {
            Class<?> clazz = Class.forName(string);
            editorFeeder = (EditorFeeder)clazz.newInstance();
            editorFeeder.initialize(remoteResourceWrapper, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("StringArrayEditor mis-configured:  unable to instantiate " + string + ".");
        }
        this.frame = ((org.w3c.jigadmin.RemoteResourceWrapper)remoteResourceWrapper).getServerBrowser().getFrame();
        this.oldshortarray = (short[][])object;
        this.createComponent(editorFeeder, this.toStringArray(this.oldshortarray));
    }
}

