/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ssi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.ssi.SSIFrame;
import org.w3c.jigsaw.ssi.commands.Command;
import org.w3c.jigsaw.ssi.commands.CommandRegistry;
import org.w3c.jigsaw.ssi.commands.ControlCommand;
import org.w3c.jigsaw.ssi.commands.ControlCommandException;
import org.w3c.util.ArrayDictionary;

public class Segment {
    protected static final int UNPARSED = 0;
    protected static final int COMMAND = 1;
    protected static final String SEPARATOR = "|";
    protected boolean control = false;
    protected SSIFrame ssiframe = null;
    protected Request request = null;
    int start = 0;
    int end = 0;
    String commandName = null;
    private Command command = null;
    private CommandRegistry registry = null;
    ArrayDictionary parameters = null;

    public boolean isControl() {
        return this.control;
    }

    public Segment(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public Segment(SSIFrame sSIFrame, String string, ArrayDictionary arrayDictionary, int n, int n2) {
        this.ssiframe = sSIFrame;
        this.commandName = string;
        this.parameters = arrayDictionary;
        this.start = n;
        this.end = n2;
    }

    protected Segment() {
        this.end = -1;
        this.start = -1;
    }

    public String pickle() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.commandName != null) {
            stringBuffer.append(1);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.start);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.end);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.parameters.size());
            for (int i = 0; i < this.parameters.capacity() && this.parameters.keyAt(i) != null; ++i) {
                stringBuffer.append(SEPARATOR);
                stringBuffer.append((String)this.parameters.keyAt(i));
                stringBuffer.append(SEPARATOR);
                stringBuffer.append((String)this.parameters.elementAt(i));
            }
        } else {
            stringBuffer.append(0);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.start);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.end);
        }
        return stringBuffer.toString();
    }

    public static Segment unpickle(String string) {
        Segment segment = new Segment();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            segment.start = Integer.parseInt(stringTokenizer.nextToken());
            segment.end = Integer.parseInt(stringTokenizer.nextToken());
            if (n == 1) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                Object[] objectArray = new String[n2];
                Object[] objectArray2 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = stringTokenizer.nextToken();
                    objectArray2[i] = stringTokenizer.nextToken();
                }
                segment.parameters = new ArrayDictionary(objectArray, objectArray2);
            } else {
                segment.commandName = null;
                segment.parameters = null;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        return segment;
    }

    public void pickle(DataOutputStream dataOutputStream) throws IOException {
        if (this.commandName != null) {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.start);
            dataOutputStream.writeInt(this.end);
            dataOutputStream.writeUTF(this.commandName);
            dataOutputStream.writeInt(this.parameters.size());
            for (int i = 0; i < this.parameters.capacity() && this.parameters.keyAt(i) != null; ++i) {
                dataOutputStream.writeUTF((String)this.parameters.keyAt(i));
                dataOutputStream.writeUTF((String)this.parameters.elementAt(i));
            }
        } else {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(this.start);
            dataOutputStream.writeInt(this.end);
        }
    }

    public static Segment unpickle(DataInputStream dataInputStream) throws IOException {
        Segment segment = new Segment();
        int n = dataInputStream.readInt();
        segment.start = dataInputStream.readInt();
        segment.end = dataInputStream.readInt();
        if (n == 1) {
            segment.commandName = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            Object[] objectArray = new String[n2];
            Object[] objectArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = dataInputStream.readUTF();
                objectArray2[i] = dataInputStream.readUTF();
            }
            segment.parameters = new ArrayDictionary(objectArray, objectArray2);
        } else {
            segment.commandName = null;
            segment.parameters = null;
        }
        return segment;
    }

    public final boolean isUnparsed() {
        return this.commandName == null;
    }

    public final String toString() {
        return this.commandName != null ? "<" + this.start + ',' + this.end + ": " + this.commandName + " " + this.parameters + '>' : "<" + this.start + ',' + this.end + '>';
    }

    public int jumpTo() throws ControlCommandException {
        if (!this.control || this.command == null) {
            throw new ControlCommandException("SEGMENT", "Internal Error");
        }
        ControlCommand controlCommand = (ControlCommand)this.command;
        int n = 0;
        n = controlCommand.jumpTo(this.ssiframe, this.request, this.registry, this.parameters, this.ssiframe.vars);
        return n;
    }

    public final Reply get() {
        if (this.command == null) {
            return null;
        }
        return this.command.execute(this.ssiframe, this.request, this.parameters, this.ssiframe.vars);
    }

    public boolean needsRevalidate() {
        if (this.command == null) {
            return false;
        }
        return !this.command.acceptCaching();
    }

    public final Reply init(SSIFrame sSIFrame, Request request, Dictionary dictionary, CommandRegistry commandRegistry, int n) {
        if (this.commandName == null) {
            return null;
        }
        this.ssiframe = sSIFrame;
        this.request = request;
        if (this.command == null || commandRegistry != this.registry) {
            this.registry = commandRegistry;
            this.command = commandRegistry.lookupCommand(this.commandName);
            this.control = this.command instanceof ControlCommand;
        }
        if (this.control) {
            ControlCommand controlCommand = (ControlCommand)this.command;
            controlCommand.setPosition(sSIFrame, request, commandRegistry, this.parameters, dictionary, n);
            sSIFrame.doNotCacheReply();
            return null;
        }
        if (sSIFrame.cacheReplies() && this.command.acceptCaching()) {
            return this.get();
        }
        return null;
    }
}

