/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.util.Hashtable;
import org.w3c.www.mux.MuxProtocolHandler;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxStream;
import org.w3c.www.mux.MuxStreamHandler;

public class SampleMuxHandler
implements MuxStreamHandler {
    private static final boolean debug = false;
    public static final int ECHO = 7;
    public static final int DISCARD = 9;
    protected static SampleMuxHandler sample = null;
    protected Hashtable protocols = new Hashtable();

    protected void log(String string) {
        System.out.println("[" + this.getClass().getName() + "]: " + string);
    }

    public static synchronized MuxStreamHandler getStreamHandler() {
        if (sample == null) {
            sample = new SampleMuxHandler();
        }
        return sample;
    }

    public boolean acceptSession(MuxStream muxStream, int n, int n2) {
        Object v = this.protocols.get(new Integer(n2));
        return v != null;
    }

    public void notifySession(MuxSession muxSession) {
        int n = muxSession.getProtocolIdentifier();
        Integer n2 = new Integer(n);
        Object v = this.protocols.get(n2);
        if (v == null) {
            this.log("SampleMuxHandler: unknown protocol " + n);
            try {
                muxSession.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MuxProtocolHandler muxProtocolHandler = null;
        if (v instanceof String) {
            String string = (String)v;
            try {
                Class<?> clazz = Class.forName(string);
                muxProtocolHandler = (MuxProtocolHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                this.log("Instantiating handler for " + n + " of class \"" + string + "\" failed.");
                exception.printStackTrace();
                try {
                    muxSession.shutdown();
                }
                catch (IOException iOException) {}
            }
        } else if (v instanceof MuxProtocolHandler) {
            muxProtocolHandler = (MuxProtocolHandler)v;
        } else {
            this.log("SampleMuxHandler: unknown protocol " + n);
            try {
                muxSession.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            muxProtocolHandler.initialize(muxSession);
        }
        catch (Exception exception) {
            this.log("Launching handler for " + n + " of class \"" + muxProtocolHandler.getClass() + "\" failed.");
            exception.printStackTrace();
            try {
                muxSession.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void registerHandler(int n, String string) {
        this.protocols.put(new Integer(n), string);
    }

    public void registerHandler(int n, MuxProtocolHandler muxProtocolHandler) {
        this.protocols.put(new Integer(n), muxProtocolHandler);
    }

    public void unregisterHandler(int n) {
        this.protocols.remove(new Integer(n));
    }

    public void registerDefaultHandlers() {
        this.registerHandler(7, "org.w3c.www.mux.handlers.Echo");
        this.registerHandler(9, "org.w3c.www.mux.handlers.Discard");
    }

    public SampleMuxHandler() {
        this.registerDefaultHandlers();
    }
}

