/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.LogContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;
import net.zerotoaster.httpd.util.RuleSet;
import net.zerotoaster.httpd.util.RuleSetLine;

public class Mod_Scripting
extends Mod_Base {
    protected RuleSet[] rsRequestRuleSet = null;
    protected Hashtable hshHdr = null;
    protected Hashtable hshEnv = null;

    public Mod_Scripting(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    private boolean matches(RuleSet[] rsRuleSets, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        boolean blnOneMatched = false;
        String strTmp = null;
        int rs = 0;
        while (rs < rsRuleSets.length) {
            RuleSet rsSet = rsRuleSets[rs];
            rsSet.blnUseIt = true;
            int intLastBoolean = 1;
            boolean blnState = false;
            int i = 0;
            while (i < rsSet.rsl.length) {
                RuleSetLine rsl = rsSet.rsl[i];
                if (rsl.intCmd >= 99) break;
                blnState = false;
                if (rsl.intCmd < 10) {
                    intLastBoolean = rsl.intCmd;
                } else {
                    switch (rsl.intCmd) {
                        case 12: {
                            try {
                                IP_Network ipn = new IP_Network(rsl.strArg1, rsl.strArg2);
                                blnState = ipn.match(imd.strRemoteServerAddress);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.logContext.write("? Illegal Host, Netmask " + rsl.strArg1 + "," + rsl.strArg2);
                            }
                            break;
                        }
                        case 10: {
                            strTmp = (String)this.hshEnv.get(rsl.strArg1.toUpperCase());
                            if (strTmp == null) break;
                            blnState = Helper.checkString(strTmp, rsl.strArg2);
                            break;
                        }
                        case 11: {
                            String[] strHDR = (String[])this.hshHdr.get(rsl.strArg1.toUpperCase());
                            if (strHDR == null) break;
                            int h = 0;
                            while (h < strHDR.length) {
                                blnState |= Helper.checkString(strHDR[h], rsl.strArg2);
                                ++h;
                            }
                            break;
                        }
                    }
                    switch (intLastBoolean) {
                        case 0: {
                            rsSet.blnUseIt |= blnState;
                            intLastBoolean = -1;
                            break;
                        }
                        case 1: {
                            rsSet.blnUseIt &= blnState;
                            intLastBoolean = -1;
                            break;
                        }
                        case 2: {
                            rsSet.blnUseIt = rsSet.blnUseIt | !blnState;
                            intLastBoolean = -1;
                            break;
                        }
                        case 3: {
                            rsSet.blnUseIt = rsSet.blnUseIt & !blnState;
                            intLastBoolean = -1;
                        }
                    }
                }
                ++i;
            }
            blnOneMatched |= rsSet.blnUseIt;
            ++rs;
        }
        return blnOneMatched;
    }

    private RuleSet[] parseRuleFiles(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String[] strRuleFiles = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "ruleset", new String[0]);
        Vector<RuleSet> vecRuleSets = new Vector<RuleSet>(strRuleFiles.length);
        this.logContext.write("D Found " + strRuleFiles.length + " rulefiles.");
        int i = 0;
        while (i < strRuleFiles.length) {
            File flRuleFile;
            String strRuleFile = strRuleFiles[i];
            if (!HelperPath.isAbsolutePath((String)strRuleFile)) {
                strRuleFile = HelperPath.pathFixup((String)(String.valueOf(imd.strConfigDir) + File.separator + strRuleFile), (String)File.separator);
            }
            if (!(flRuleFile = new File(strRuleFile)).exists()) {
                this.logContext.write("? Ruleset " + strRuleFile + " not found");
            } else {
                Object var11_12;
                Vector<RuleSetLine> v = new Vector<RuleSetLine>();
                BufferedReader br = null;
                try {
                    try {
                        String strBuffer = null;
                        int intLine = 0;
                        br = new BufferedReader(new FileReader(flRuleFile));
                        while ((strBuffer = br.readLine()) != null) {
                            ++intLine;
                            if ((strBuffer = strBuffer.trim()).length() == 0 || "#!;".indexOf(strBuffer.charAt(0)) != -1) continue;
                            RuleSetLine rsl = new RuleSetLine();
                            if (rsl.parse(strBuffer)) {
                                v.addElement(rsl);
                                continue;
                            }
                            this.logContext.write("? Cannot parse ruleset " + strRuleFile + " Line " + intLine + ": " + strBuffer);
                        }
                    }
                    catch (Throwable t) {
                        this.logContext.write("? Error reading ruleset " + strRuleFile, t);
                    }
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    Helper.close(br);
                    throw throwable;
                }
                var11_12 = null;
                Helper.close(br);
                if (v.size() != 0) {
                    RuleSet rs = new RuleSet();
                    rs.rsl = new RuleSetLine[v.size()];
                    v.copyInto(rs.rsl);
                    vecRuleSets.addElement(rs);
                }
            }
            ++i;
        }
        Object[] rs = new RuleSet[vecRuleSets.size()];
        vecRuleSets.copyInto(rs);
        return rs;
    }

    private void processActions(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        int rs = 0;
        while (rs < this.rsRequestRuleSet.length) {
            RuleSet rsSet = this.rsRequestRuleSet[rs];
            if (rsSet.blnUseIt) {
                int i = 0;
                while (i < rsSet.rsl.length) {
                    RuleSetLine rsl = rsSet.rsl[i];
                    if (rsl.intCmd >= 99) {
                        switch (rsl.intCmd) {
                            case 100: {
                                imd.strHTDOCS = HelperPath.pathFixup((String)rsl.strArg1, (String)File.separator);
                                imd.strHTDOCS = this.replaceEnv(imd.strHTDOCS);
                                break;
                            }
                            case 101: {
                                imd.strHTDOCS = HelperPath.pathFixup((String)(String.valueOf(imd.strHTDOCS) + File.separator + rsl.strArg1), (String)File.separator);
                                imd.strHTDOCS = this.replaceEnv(imd.strHTDOCS);
                                break;
                            }
                            case 102: {
                                try {
                                    httpRES.intStatusCode = Integer.parseInt(rsl.strArg1);
                                    if (rsl.strArg2 == null) break;
                                    httpRES.strStatusCode = rsl.strArg2;
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            case 103: {
                                httpRES.setSingleHeader(rsl.strArg1, this.replaceEnv(rsl.strArg2));
                                break;
                            }
                            case 104: {
                                httpREQ.strURL = this.replaceEnv(rsl.strArg1);
                                break;
                            }
                            case 105: {
                                httpREQ.strURLAbsolute = this.replaceEnv(rsl.strArg1);
                                break;
                            }
                            case 106: {
                                httpRES.intStatusCode = 302;
                                httpRES.strStatusCode = "Redirected";
                                httpRES.strLocation = this.replaceEnv(rsl.strArg1);
                            }
                        }
                    }
                    ++i;
                }
            }
            ++rs;
        }
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.isEnabled(imd, true)) {
            return false;
        }
        this.hshEnv = this.createEnvironment(httpREQ, imd, httpRES);
        this.hshHdr = httpREQ.getHeaderAsHashtable();
        Enumeration e = this.hshHdr.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            Object objData = this.hshHdr.remove(strKey);
            this.hshHdr.put(strKey.toUpperCase(), objData);
        }
        this.rsRequestRuleSet = this.parseRuleFiles(httpREQ, imd, httpRES);
        if (this.matches(this.rsRequestRuleSet, httpREQ, imd, httpRES)) {
            this.processActions(httpREQ, imd, httpRES);
        }
        this.rsRequestRuleSet = null;
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    private String replaceEnv(String string) {
        String strArg;
        int intLoop = 5;
        while (intLoop-- > 0) {
            int pp1 = string.indexOf("%");
            if (pp1 == -1) {
                return string;
            }
            int pp2 = string.indexOf("%", pp1 + 1);
            if (pp2 == -1) {
                return string;
            }
            String strSearch = string.substring(pp1 + 1, pp2);
            if (strSearch.length() == 0) {
                return string;
            }
            String strEnv = (String)this.hshEnv.get(strSearch);
            if (strEnv == null) {
                return string;
            }
            strArg = String.valueOf(string.substring(0, pp1)) + strEnv + string.substring(pp2 + 1);
        }
        return strArg;
    }

    public static void _main(String[] args) {
        Mod_Scripting m = new Mod_Scripting(null, null);
        m.hshEnv = new Hashtable();
        m.hshEnv.put("DOCUMENT_NAME", "12345");
        m.hshEnv.put("URL", "67890");
        String strArg = "http://DOCUMENT_NAME";
        System.out.println(m.replaceEnv(strArg));
    }
}

