/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.GlobalStatistics_Record;
import net.zerotoaster.httpd.util.Helper;
import net.zerotoaster.httpd.util.Statistics;
import net.zerotoaster.httpd.util.Statistics_Record;

public class Mod_Statistics
extends Mod_Base {
    private static Hashtable hshVHosts = new Hashtable();
    private static long lngCPLastSaved = 0L;
    private static Configuration cnfStatic = null;
    protected String strURLPath = null;
    protected String strStatFilePath = null;
    protected PrintWriter pw = null;

    public Mod_Statistics(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
        cnfStatic = cnfConfig;
    }

    public static final synchronized void dumpCheckpoints(long lngSaveInterval, LogContext logContext) {
        String strCPLastSaved;
        boolean blnDateChange;
        if (cnfStatic == null) {
            return;
        }
        long lngTime = TimeFactory.getTime();
        if (lngCPLastSaved == 0L) {
            lngCPLastSaved = lngTime;
            return;
        }
        String strCurrentCP_File = HelperDT.getYYYYMMDD((Date)new Date(lngTime));
        boolean bl = blnDateChange = !strCurrentCP_File.equals(strCPLastSaved = HelperDT.getYYYYMMDD((Date)new Date(lngCPLastSaved)));
        if (!(lngTime - lngCPLastSaved >= lngSaveInterval && lngSaveInterval != 0L || blnDateChange)) {
            return;
        }
        lngCPLastSaved = lngTime;
        PrintWriter pw = null;
        Statistics[] stats = Mod_Statistics.getStatistics();
        logContext.write("D Dumping statistic checkpoints, " + stats.length + " hosts");
        int i = 0;
        while (i < stats.length) {
            Object var11_9;
            try {
                try {
                    Statistics sr = stats[i];
                    new File(sr.getCheckpointPath()).mkdirs();
                    pw = new PrintWriter(new FileWriter(new File(sr.getCheckpointPath(), String.valueOf(strCPLastSaved) + ".chk")));
                    sr.export_binary(pw);
                    Helper.close(pw);
                    pw = new PrintWriter(new FileWriter(new File(sr.getCheckpointPath(), String.valueOf(strCPLastSaved) + ".txt")));
                    sr.export_text(pw);
                    if (blnDateChange) {
                        sr.reset();
                    }
                }
                catch (Throwable t) {
                    logContext.write("? Error dumping checkpoint " + strCPLastSaved, t);
                }
            }
            catch (Throwable throwable) {
                var11_9 = null;
                Helper.close(pw);
                throw throwable;
            }
            var11_9 = null;
            Helper.close(pw);
            ++i;
        }
    }

    private final Statistics getStatisticRecord(String strKey, IntermediateModuleData imd) {
        String strCP_File;
        File flCP;
        Statistics sr = (Statistics)hshVHosts.get(strKey);
        if (sr != null) {
            return sr;
        }
        String strCP_Dir = null;
        if (strKey.equals("@globalstatistics@")) {
            strCP_Dir = HelperPath.pathFixup((String)this.cnfConfig.strServerCheckpointDir, (String)File.separator);
            sr = new GlobalStatistics_Record();
        }
        if (strCP_Dir == null) {
            strCP_Dir = imd.iniVHOST.getPropertyString(this.MOD_NAME, "checkpoint_dir", "statistics");
            strCP_Dir = HelperPath.pathFixup((String)(String.valueOf(imd.strConfigDir) + File.separator + strCP_Dir), (String)File.separator);
            sr = new Statistics_Record();
        }
        if ((flCP = new File(strCP_Dir, strCP_File = String.valueOf(HelperDT.getYYYYMMDD((Date)new Date(TimeFactory.getTime()))) + ".chk")).exists() && flCP.length() > 1L) {
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(flCP));
                    sr.import_binary(br);
                }
                catch (Throwable e) {
                    this.logContext.write("? Error loading checkpointfile " + flCP.getPath(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Helper.close(br);
                throw throwable;
            }
            Object var8_11 = null;
            Helper.close(br);
        }
        sr.setCheckpointPath(strCP_Dir);
        hshVHosts.put(strKey, sr);
        return sr;
    }

    public static final Statistics[] getStatistics() {
        Statistics[] stats = new Statistics[hshVHosts.size()];
        int i = 0;
        Enumeration e = hshVHosts.elements();
        while (e.hasMoreElements()) {
            stats[i++] = (Statistics)e.nextElement();
        }
        return stats;
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        this.blnIsRequestForUs = false;
        if (!this.blnIsRequestForUs) {
            return false;
        }
        if (httpRES.intStatusCode != 0) {
            return false;
        }
        String strStatURL = imd.iniVHOST.getPropertyString(this.MOD_NAME, "statistics_url", "/statistics/");
        if (strStatURL.length() == 0 || !httpREQ.strURL.startsWith(strStatURL)) {
            return false;
        }
        this.strURLPath = httpREQ.strURL.substring(strStatURL.length());
        this.strStatFilePath = String.valueOf(imd.strConfigDir) + File.separator + imd.iniVHOST.getPropertyString(this.MOD_NAME, "checkpoint_dir", "statistics");
        this.strStatFilePath = HelperPath.removeTrailingSlashes((String)this.strStatFilePath);
        this.blnIsRequestForUs = true;
        return true;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.blnIsRequestForUs) {
            return false;
        }
        httpRES.strConnection = "close";
        httpRES.strContentType = "text/html";
        this.pw = new PrintWriter(httpRES.osResponse);
        this.pw.println("<html><head><title>Usage statistics</title></head>");
        this.pw.println("<body>");
        this.sd_handleContent(imd);
        this.pw.println("</body></head>");
        this.pw.flush();
        return true;
    }

    private String[] sd_collectStatFiles(IntermediateModuleData imd, String strSelection) {
        Vector<Object> v = null;
        int intCmpLen = strSelection.length();
        switch (intCmpLen) {
            case 0: {
                v = new Vector(744, 372);
                break;
            }
            case 4: {
                v = new Vector<Object>(372);
                break;
            }
            case 6: {
                v = new Vector(31);
                break;
            }
            case 8: {
                v = new Vector(1);
            }
        }
        File f = new File(this.strStatFilePath);
        Object[] s = f.list();
        if (s == null || s.length == 0) {
            return new String[0];
        }
        int i = 0;
        while (i < s.length) {
            if (s[i].endsWith(".chk") && ((String)s[i]).substring(0, intCmpLen).equals(strSelection)) {
                v.addElement(s[i]);
            }
            ++i;
        }
        s = new String[v.size()];
        v.copyInto(s);
        HelperSort.quick((Object[])s, (Comparator)new ComparatorString());
        return s;
    }

    private Statistics_Record[] sd_cumulateStatFiles(String[] strStatFiles, String strURLPart) throws IOException {
        Vector<Statistics_Record> vecSum = new Vector<Statistics_Record>(31);
        int intCBLength = 0;
        switch (strURLPart.length()) {
            case 0: {
                intCBLength = 4;
                break;
            }
            case 4: {
                intCBLength = 6;
                break;
            }
            case 6: {
                intCBLength = 8;
            }
        }
        String strCurrentCBValue = "";
        Statistics_Record srSum = null;
        Statistics_Record srThis = new Statistics_Record();
        int i = 0;
        while (i < strStatFiles.length) {
            if (!strCurrentCBValue.equals(strStatFiles[i].substring(0, intCBLength))) {
                if (strCurrentCBValue.length() > 0) {
                    vecSum.addElement(srSum);
                }
                srSum = new Statistics_Record();
                strCurrentCBValue = strStatFiles[i].substring(0, intCBLength);
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(new File(this.strStatFilePath, strStatFiles[i])));
                srThis.reset();
                srThis.import_binary(br);
            }
            catch (Throwable throwable) {
                Helper.close(br);
            }
            srSum.addResponse(srThis, i == strStatFiles.length - 1);
            ++i;
        }
        if (strCurrentCBValue.length() > 0) {
            vecSum.addElement(srSum);
        }
        Object[] sr = new Statistics_Record[vecSum.size()];
        vecSum.copyInto(sr);
        return sr;
    }

    private void sd_handleContent(IntermediateModuleData imd) {
        try {
            String[] strStatFiles = this.sd_collectStatFiles(imd, this.strURLPath);
            Statistics_Record[] srSum = this.sd_cumulateStatFiles(strStatFiles, this.strURLPath);
            this.sd_outputStatistics(strStatFiles, srSum);
        }
        catch (IOException e) {
            this.pw.println("Error processing statistics: " + e.toString());
            this.logContext.write("? Error processing statistics", (Throwable)e);
        }
    }

    private void sd_outputStatistics(String[] strStatFiles, Statistics_Record[] srSum) {
        if (srSum == null || srSum.length == 0) {
            return;
        }
        this.pw.println("Statistics from " + strStatFiles[0] + " to " + strStatFiles[strStatFiles.length - 1]);
        this.pw.print("<pre>");
        int i = 0;
        while (i < srSum.length) {
            srSum[i].setDetailLevel(1);
            srSum[i].export_text(this.pw);
            this.pw.print("<hr>");
            ++i;
        }
        this.pw.print("</pre>");
    }

    public void statAdd(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "create_statistics", true)) {
            return;
        }
        this.getStatisticRecord(imd.iniVHOST.getFileName(), imd).addResponse(httpREQ, imd, httpRES);
        this.getStatisticRecord("@globalstatistics@", null).addResponse(httpREQ, imd, httpRES);
    }
}

