/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.IniManager;
import de.zwanzigeins.util.LockObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import net.zerotoaster.httpd.mods.IntermediateModuleData;

public final class Helper {
    private static Hashtable hshLockedFiles = new Hashtable();

    private Helper() {
    }

    public static final boolean checkString(String string, String string2) {
        String s = string.toLowerCase();
        String templ = string2.toLowerCase();
        int wildPos = templ.indexOf(42);
        if (wildPos == -1) {
            return s.equals(templ);
        }
        int templLen = templ.length();
        int strLen = s.length();
        int templIndex = 0;
        int strIndex = 0;
        boolean wildCard = false;
        while (templIndex < templLen) {
            if (templ.charAt(templIndex) == '*') {
                wildCard = true;
                ++templIndex;
                continue;
            }
            int nextWild = templ.indexOf(42, templIndex);
            if (nextWild == -1) {
                nextWild = templLen;
            }
            String templPart = templ.substring(templIndex, nextWild);
            templIndex = nextWild;
            if (wildCard) {
                int pos = s.indexOf(templPart);
                if (pos == -1) {
                    return false;
                }
                strIndex = pos + templPart.length();
            } else {
                if (!s.regionMatches(false, 0, templPart, 0, templPart.length())) {
                    return false;
                }
                strIndex += templPart.length();
            }
            wildCard = false;
        }
        return wildCard ? true : strIndex == strLen;
    }

    public static final void close(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return;
            }
            if (o instanceof Socket) {
                ((Socket)o).close();
                return;
            }
            if (o instanceof ServerSocket) {
                ((ServerSocket)o).close();
                return;
            }
            if (o instanceof RandomAccessFile) {
                ((RandomAccessFile)o).close();
                return;
            }
            if (o instanceof ZipFile) {
                ((ZipFile)o).close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public static final String fromHexURL(String str) {
        if (str.indexOf("%") == -1) {
            return str;
        }
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%' && i < str.length() - 2) {
                String s = "";
                s = String.valueOf(s) + str.charAt(++i);
                s = String.valueOf(s) + str.charAt(++i);
                try {
                    strb.append((char)Integer.parseInt(s.toLowerCase(), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    strb.append("%");
                    strb.append(s);
                }
            } else {
                strb.append(str.charAt(i));
            }
            ++i;
        }
        return strb.toString();
    }

    public static final long fromHTTPDate(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "en"));
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        try {
            return sdf.parse(s).getTime();
        }
        catch (ParseException parseException) {
            return -1L;
        }
    }

    public static final File getCacheFile(IntermediateModuleData imd) {
        String strCmp1 = imd.strHTDOCS.toLowerCase();
        String strCmp2 = imd.strFileToServe.toLowerCase();
        String strCache = "";
        if (strCmp2.startsWith(strCmp1)) {
            strCache = imd.strFileToServe.substring(imd.strHTDOCS.length());
            strCache = HelperPath.removeLeadingSlashes((String)strCache);
        } else {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString());
            }
            strCache = HelperFormat.hexDigit((byte[])md.digest(imd.strFileToServe.getBytes()));
        }
        return new File(String.valueOf(imd.strTEMPFILES) + File.separator + "cached", strCache);
    }

    public static final String getMimeType(IniManager iniVHOST, String strFile) {
        String strExt = "default";
        int pp = strFile.lastIndexOf(".");
        strExt = pp != -1 ? strFile.substring(pp + 1).trim().toLowerCase() : strFile.toLowerCase();
        String strContentType = iniVHOST.getPropertyString("MIME", strExt, "");
        if (strContentType.length() == 0) {
            strContentType = iniVHOST.getPropertyString("MIME", "default");
        }
        return strContentType;
    }

    public static final String hexDigit(byte x) {
        String s = "";
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        return s;
    }

    public static final Hashtable parseQueryString(String strQuery) {
        Hashtable<String, String[]> hshQuery = new Hashtable<String, String[]>();
        if (strQuery == null) {
            return hshQuery;
        }
        StringTokenizer strt = new StringTokenizer(strQuery, "&");
        while (strt.hasMoreTokens()) {
            String strPart = strt.nextToken();
            strPart = strPart.replace('+', ' ');
            strPart = Helper.fromHexURL(strPart);
            String strKey = null;
            String strData = null;
            int pp = strPart.indexOf("=");
            if (pp == -1) {
                strKey = strPart;
                strData = "";
            } else {
                strKey = strPart.substring(0, pp);
                strData = strPart.substring(pp + 1);
            }
            if (!hshQuery.containsKey(strKey)) {
                hshQuery.put(strKey, new String[]{strData});
                continue;
            }
            String[] strDataOld = (String[])hshQuery.get(strKey);
            String[] strDataNew = new String[strDataOld.length + 1];
            System.arraycopy(strDataOld, 0, strDataNew, 0, strDataOld.length);
            strDataNew[strDataOld.length] = strData;
            hshQuery.put(strKey, strDataNew);
        }
        return hshQuery;
    }

    public static final String toHexURL(String str) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch <= ' ' || ch >= '~') {
                strb.append("%");
                strb.append(Helper.hexDigit((byte)ch));
            } else {
                strb.append(ch);
            }
            ++i;
        }
        return strb.toString();
    }

    public static final String toHTTPDate(long lngTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "en"));
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return sdf.format(new Date(lngTime));
    }

    public static final void wait_ms(long t) {
        LockObject objLock = new LockObject();
        objLock.lo_wait(t);
        objLock.dispose();
    }
}

